/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.base.devserver.IdeIntegration;
import com.vaadin.base.devserver.OpenInCurrentIde;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import elemental.json.JsonObject;
import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenComponentInIDE
implements CopilotCommand {
    IdeIntegration ideIntegration;

    public OpenComponentInIDE(ApplicationConfiguration applicationConfiguration) {
        this.ideIntegration = new IdeIntegration(applicationConfiguration);
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("show-in-ide")) {
            if (data.hasKey("nodeId")) {
                this.showFlowComponent((int)data.getNumber("uiId"), (int)data.getNumber("nodeId"));
            } else {
                this.showReactComponent(data.getString("fileName"), (int)data.getNumber("lineNumber"));
            }
            return true;
        }
        return false;
    }

    public void showFlowComponent(int uiId, int nodeId) {
        VaadinSession session = VaadinSession.getCurrent();
        session.access((Command & Serializable)() -> {
            Element element = session.findElement(uiId, nodeId);
            Optional c = element.getComponent();
            if (c.isPresent()) {
                this.ideIntegration.showComponentCreateInIde((Component)c.get());
            } else {
                this.getLogger().error("Only component locations are tracked. The given node id refers to an element and not a component");
            }
        });
    }

    public void showReactComponent(String filename, int lineNumber) {
        File file = new File(filename);
        OpenInCurrentIde.openFile((File)file, (int)lineNumber);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

