/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.plugins.themeeditor.handlers;

import com.vaadin.base.devserver.OpenInCurrentIde;
import com.vaadin.copilot.plugins.themeeditor.ThemeEditorCommand;
import com.vaadin.copilot.plugins.themeeditor.messages.BaseResponse;
import com.vaadin.copilot.plugins.themeeditor.messages.OpenCssRequest;
import com.vaadin.copilot.plugins.themeeditor.utils.HasThemeModifier;
import com.vaadin.copilot.plugins.themeeditor.utils.MessageHandler;
import com.vaadin.copilot.plugins.themeeditor.utils.ThemeEditorException;
import com.vaadin.flow.internal.JsonUtils;
import elemental.json.JsonObject;
import java.io.File;
import java.util.Optional;

public class OpenCssHandler
implements MessageHandler {
    private HasThemeModifier hasThemeModifier;

    public OpenCssHandler(HasThemeModifier hasThemeModifier) {
        this.hasThemeModifier = hasThemeModifier;
    }

    @Override
    public MessageHandler.ExecuteAndUndo handle(JsonObject data) {
        OpenCssRequest request = (OpenCssRequest)JsonUtils.readToObject((JsonObject)data, OpenCssRequest.class);
        String selector = request.getSelector();
        this.hasThemeModifier.getThemeModifier().ensureFilesExist();
        return new MessageHandler.ExecuteAndUndo(() -> {
            File stylesheet = this.hasThemeModifier.getThemeModifier().getStyleSheetFile();
            int line = this.hasThemeModifier.getThemeModifier().getRuleLocationLine(selector);
            if (line == -1) {
                this.hasThemeModifier.getThemeModifier().createEmptyStyleRule(selector);
                line = this.hasThemeModifier.getThemeModifier().getRuleLocationLine(selector);
                if (line == -1) {
                    throw new ThemeEditorException("Cannot create empty rule for " + selector);
                }
            }
            if (!OpenInCurrentIde.openFile((File)stylesheet, (int)line)) {
                throw new ThemeEditorException("Cannot open " + stylesheet.getAbsolutePath() + ":" + line);
            }
            return BaseResponse.ok();
        }, Optional.empty());
    }

    @Override
    public String getCommandName() {
        return ThemeEditorCommand.OPEN_CSS.getValue();
    }
}

