/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.CopilotVersion;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.LicenseException;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.ProKey;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserInfoHandler
implements CopilotCommand {
    public static final String PRODUCT_VAADIN_EMPLOYEE = "vaadin-employee";
    public static final String PRODUCT_VAADIN_COPILOT = "vaadin-copilot";

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("get-user-info")) {
            ProKey proKey = LocalProKey.get();
            String[] accessTo = new String[]{};
            if (proKey != null) {
                accessTo = this.queryAccessTo(proKey);
            }
            JsonObject userInfo = Json.createObject();
            if (proKey != null) {
                userInfo.put("proKey", proKey.getProKey());
            }
            JsonArray accessValues = (JsonArray)Arrays.stream(accessTo).map(Json::create).collect(JsonUtils.asArray());
            userInfo.put("accessTo", (JsonValue)accessValues);
            userInfo.put("reqId", data.getString("reqId"));
            devToolsInterface.send("copilot-user-info", userInfo);
            return true;
        }
        if (command.equals("log-in")) {
            ProKey proKey = LocalProKey.get();
            JsonObject response = Json.createObject();
            response.put("reqId", data.getString("reqId"));
            if (proKey == null) {
                LicenseChecker.checkLicense((String)PRODUCT_VAADIN_COPILOT, (String)CopilotVersion.getVersion(), (BuildType)BuildType.DEVELOPMENT, loginUrl -> {
                    response.put("loginUrl", loginUrl);
                    devToolsInterface.send("log-in-resp", response);
                });
            }
            return true;
        }
        return false;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    private String[] queryAccessTo(ProKey proKey) {
        ArrayList<String> access;
        block5: {
            block4: {
                access = new ArrayList<String>();
                try {
                    LicenseChecker.checkLicense((String)PRODUCT_VAADIN_EMPLOYEE, (String)"1.0.0", (BuildType)BuildType.DEVELOPMENT);
                    access.add(PRODUCT_VAADIN_EMPLOYEE);
                }
                catch (LicenseException e) {
                    if (this.ignoreWhenDoingBackgroundCheck(e)) break block4;
                    this.getLogger().error("Problem checking the sub status", (Throwable)e);
                }
            }
            try {
                LicenseChecker.checkLicense((String)PRODUCT_VAADIN_COPILOT, (String)CopilotVersion.getVersion(), (BuildType)BuildType.DEVELOPMENT);
                access.add(PRODUCT_VAADIN_COPILOT);
            }
            catch (LicenseException e) {
                if (this.ignoreWhenDoingBackgroundCheck(e)) break block5;
                this.getLogger().error("Problem checking the subscription status", (Throwable)e);
            }
        }
        return (String[])access.toArray(String[]::new);
    }

    private boolean ignoreWhenDoingBackgroundCheck(LicenseException e) {
        String msg = e.getMessage();
        if (msg.contains("The provided license key does not allow usage")) {
            return true;
        }
        return msg.contains("could not be reached and no offline key was found");
    }
}

