/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.ActivationHandler;
import com.vaadin.collaborationengine.ConnectionContext;
import com.vaadin.collaborationengine.SingleUseActivationHandler;
import com.vaadin.collaborationengine.TopicConnection;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class TopicConnectionRegistration
implements Registration {
    private final AtomicReference<TopicConnection> topicConnectionReference;
    private ConnectionContext connectionContext;
    private Executor executor;
    private CompletableFuture<Void> pendingFuture;
    private final Consumer<TopicConnectionRegistration> afterDisconnection;

    TopicConnectionRegistration(TopicConnection topicConnection, ConnectionContext connectionContext, Executor executor, Consumer<TopicConnectionRegistration> afterDisconnection) {
        this.topicConnectionReference = new AtomicReference<TopicConnection>(topicConnection);
        this.connectionContext = connectionContext;
        this.executor = executor;
        this.afterDisconnection = afterDisconnection;
    }

    public void remove() {
        TopicConnection topicConnection = this.topicConnectionReference.getAndSet(null);
        if (topicConnection != null) {
            this.pendingFuture = topicConnection.deactivateAndClose();
            this.pendingFuture.thenRun(() -> {
                this.pendingFuture = null;
                this.afterDisconnection.accept(this);
            });
        }
        this.connectionContext = null;
        this.executor = null;
    }

    Optional<CompletableFuture<Void>> getPendingFuture() {
        return Optional.ofNullable(this.pendingFuture);
    }

    public void onConnectionFailed(ConnectionFailedAction connectionFailedAction) {
        Objects.requireNonNull(connectionFailedAction, "The connection failed action can't be null");
        if (this.topicConnectionReference.get() == null) {
            this.connectionContext.init(new SingleUseActivationHandler((ActivationHandler & Serializable)actionDispatcher -> {
                ConnectionFailedEvent event = new ConnectionFailedEvent(this);
                actionDispatcher.dispatchAction((Command & Serializable)() -> connectionFailedAction.onConnectionFailed(event));
            }), this.executor);
        }
    }

    @FunctionalInterface
    public static interface ConnectionFailedAction {
        public void onConnectionFailed(ConnectionFailedEvent var1);
    }

    public static class ConnectionFailedEvent
    extends EventObject {
        ConnectionFailedEvent(TopicConnectionRegistration source) {
            super(source);
        }

        @Override
        public TopicConnectionRegistration getSource() {
            return (TopicConnectionRegistration)super.getSource();
        }
    }
}

