/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class UserInfo {
    private String id;
    private String name;
    private String abbreviation;
    private String image;
    private int colorIndex;

    @JsonCreator
    public UserInfo(@JsonProperty(value="id") String userId) {
        this(userId, -1);
    }

    public UserInfo(String userId, String name) {
        this(userId);
        this.name = name;
    }

    public UserInfo(String userId, String name, String imageUrl) {
        this(userId, name);
        this.image = imageUrl;
    }

    UserInfo(String userId, int colorIndex) {
        Objects.requireNonNull(userId, "Null user id isn't supported");
        this.id = userId;
        this.colorIndex = colorIndex;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String imageUrl) {
        this.image = imageUrl;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public void setColorIndex(int colorIndex) {
        this.colorIndex = colorIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserInfo that = (UserInfo)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

