/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.AbstractCollaborationManager;
import com.vaadin.collaborationengine.CollaborationEngine;
import com.vaadin.collaborationengine.CollaborationList;
import com.vaadin.collaborationengine.ComponentConnectionContext;
import com.vaadin.collaborationengine.ConnectionContext;
import com.vaadin.collaborationengine.EntryScope;
import com.vaadin.collaborationengine.ListChangeEvent;
import com.vaadin.collaborationengine.ListKey;
import com.vaadin.collaborationengine.ListOperation;
import com.vaadin.collaborationengine.NewUserHandler;
import com.vaadin.collaborationengine.PresenceHandler;
import com.vaadin.collaborationengine.TopicConnection;
import com.vaadin.collaborationengine.UserInfo;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PresenceManager
extends AbstractCollaborationManager {
    static final Logger LOGGER;
    static final String LIST_NAME;
    private final Map<String, UserEntry> userEntries = new LinkedHashMap<String, UserEntry>();
    private ListKey ownPresenceKey;
    private CollaborationList list;
    private PresenceHandler presenceHandler;
    private boolean markAsPresent = false;
    private Registration subscribeRegistration;

    public PresenceManager(Component component, UserInfo localUser, String topicId) {
        this(new ComponentConnectionContext(component), localUser, topicId, CollaborationEngine.getInstance());
    }

    public PresenceManager(ConnectionContext context, UserInfo localUser, String topicId, CollaborationEngine collaborationEngine) {
        super(localUser, topicId, collaborationEngine);
        this.openTopicConnection(context, (SerializableFunction<TopicConnection, Registration>)((SerializableFunction & Serializable)this::onConnectionActivate));
    }

    public void markAsPresent(boolean markAsPresent) {
        if (this.markAsPresent != markAsPresent && this.list != null) {
            if (markAsPresent) {
                this.addLocalUserToTopic();
            } else {
                this.removeLocalUserFromTopic();
            }
        }
        this.markAsPresent = markAsPresent;
    }

    private void addLocalUserToTopic() {
        assert (this.ownPresenceKey == null);
        ListOperation operation = ListOperation.insertLast(this.getLocalUser()).withScope(EntryScope.CONNECTION);
        this.ownPresenceKey = this.list.apply(operation).getKey();
    }

    private void removeLocalUserFromTopic() {
        assert (this.ownPresenceKey != null);
        this.list.set(this.ownPresenceKey, null);
        this.ownPresenceKey = null;
    }

    @Deprecated
    public void setNewUserHandler(NewUserHandler handler) {
        this.setPresenceHandler(context -> handler.handleNewUser(context.getUser()));
    }

    public void setPresenceHandler(PresenceHandler handler) {
        this.resetEntries();
        this.presenceHandler = handler;
        if (handler != null && this.list != null) {
            this.subscribeRegistration = this.list.subscribe(this::onListChange);
        }
    }

    private Registration onConnectionActivate(TopicConnection topicConnection) {
        this.list = topicConnection.getNamedList(LIST_NAME);
        if (this.markAsPresent) {
            this.addLocalUserToTopic();
        }
        if (this.presenceHandler != null && this.subscribeRegistration == null) {
            this.subscribeRegistration = this.list.subscribe(this::onListChange);
        }
        return this::onConnectionDeactivate;
    }

    private void onConnectionDeactivate() {
        this.ownPresenceKey = null;
        this.list = null;
        this.resetEntries();
    }

    private void onListChange(ListChangeEvent event) {
        switch (event.getType()) {
            case INSERT: {
                this.handleNewUser(event.getValue(UserInfo.class));
                break;
            }
            case SET: {
                if (event.getValue(UserInfo.class) == null) {
                    this.handleRemovedUser(event.getOldValue(UserInfo.class));
                    break;
                }
                throw new UnsupportedOperationException("Cannot update an existing entry");
            }
        }
    }

    private void handleRemovedUser(UserInfo removedUser) {
        UserEntry userEntry = this.userEntries.get(removedUser.getId());
        this.logUserOperation("remove", removedUser, userEntry != null);
        assert (userEntry != null);
        if (--userEntry.count == 0) {
            this.removeRegistration(userEntry);
            this.userEntries.remove(removedUser.getId());
        }
    }

    private void logUserOperation(String operation, UserInfo userInfo, boolean present) {
        LOGGER.debug("{}: handle {} user {} ({}): {}present", new Object[]{this, operation, userInfo.getName(), userInfo.getId(), !present ? "not " : ""});
    }

    private void handleNewUser(UserInfo addedUser) {
        UserEntry userEntry = this.userEntries.computeIfAbsent(addedUser.getId(), ignore -> new UserEntry());
        this.logUserOperation("add", addedUser, userEntry.count == 0);
        if (userEntry.count++ == 0 && this.presenceHandler != null) {
            assert (userEntry.registration == null);
            userEntry.registration = this.presenceHandler.handlePresence(new DefaultPresenceContext(addedUser));
        }
    }

    private void removeRegistration(UserEntry entry) {
        Registration registration = entry.registration;
        if (registration != null) {
            registration.remove();
            entry.registration = null;
        }
    }

    private void resetEntries() {
        if (this.subscribeRegistration != null) {
            this.subscribeRegistration.remove();
            this.subscribeRegistration = null;
        }
        this.userEntries.values().forEach(this::removeRegistration);
        LOGGER.debug("{}: clear user entries", (Object)this);
        this.userEntries.clear();
    }

    static {
        UsageStatistics.markAsUsed((String)"vaadin-collaboration-engine/PresenceManager", (String)"5.3");
        LOGGER = LoggerFactory.getLogger(PresenceManager.class);
        LIST_NAME = PresenceManager.class.getName();
    }

    static class DefaultPresenceContext
    implements PresenceHandler.PresenceContext {
        private final UserInfo user;

        public DefaultPresenceContext(UserInfo user) {
            this.user = user;
        }

        @Override
        public UserInfo getUser() {
            return this.user;
        }
    }

    private static class UserEntry {
        private int count = 0;
        private Registration registration;

        private UserEntry() {
        }
    }
}

