/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.AccessResponse;
import com.vaadin.collaborationengine.CollaborationEngineConfiguration;
import com.vaadin.collaborationengine.ComponentConnectionContext;
import com.vaadin.collaborationengine.ConnectionContext;
import com.vaadin.collaborationengine.LicenseHandler;
import com.vaadin.collaborationengine.Topic;
import com.vaadin.collaborationengine.TopicActivationHandler;
import com.vaadin.collaborationengine.TopicConnection;
import com.vaadin.collaborationengine.TopicConnectionRegistration;
import com.vaadin.collaborationengine.UserInfo;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.shared.Registration;
import com.vaadin.pro.licensechecker.LicenseChecker;
import java.io.Serializable;
import java.time.Clock;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsModule(value="./field-highlighter/src/vaadin-field-highlighter.js")
public class CollaborationEngine {
    static final Logger LOGGER = LoggerFactory.getLogger(CollaborationEngine.class);
    static final String COLLABORATION_ENGINE_NAME = "vaadin-collaboration-engine";
    static final String COLLABORATION_ENGINE_VERSION = "3.2";
    static final int USER_COLOR_COUNT = 7;
    private Map<String, Topic> topics = new ConcurrentHashMap<String, Topic>();
    private Map<String, Integer> userColors = new ConcurrentHashMap<String, Integer>();
    private Map<String, Integer> activeTopicsCount = new ConcurrentHashMap<String, Integer>();
    private LicenseHandler licenseHandler;
    private CollaborationEngineConfiguration configuration;
    private final TopicActivationHandler topicActivationHandler;
    private Clock clock = Clock.systemUTC();

    CollaborationEngine() {
        this((topicId, isActive) -> {});
    }

    CollaborationEngine(TopicActivationHandler topicActivationHandler) {
        this.topicActivationHandler = topicActivationHandler;
    }

    private void updateTopicActivation(String topicId, Boolean isActive) {
        if (isActive.booleanValue()) {
            this.activeTopicsCount.putIfAbsent(topicId, 0);
        }
        this.activeTopicsCount.computeIfPresent(topicId, (topic, count) -> {
            int newCount;
            int n = newCount = isActive != false ? count + 1 : count - 1;
            if (newCount <= 0) {
                this.activeTopicsCount.remove(topicId);
                this.topicActivationHandler.setActive(topicId, false);
            } else if (isActive.booleanValue() && newCount == 1) {
                this.topicActivationHandler.setActive(topicId, true);
            }
            return newCount;
        });
    }

    public static CollaborationEngine getInstance() {
        return CollaborationEngine.getInstance(VaadinService.getCurrent());
    }

    public static CollaborationEngine getInstance(VaadinService vaadinService) {
        Objects.requireNonNull(vaadinService, "VaadinService cannot be null");
        return (CollaborationEngine)vaadinService.getContext().getAttribute(CollaborationEngine.class, () -> {
            if (vaadinService.getDeploymentConfiguration().isProductionMode()) {
                throw new IllegalStateException("Vaadin is running in production mode, and Collaboration Engine is missing a required configuration object. The configuration should be set by calling the static CollaborationEngine.configure() method in a VaadinServiceInitListener or, if using Spring/CDI, provide a bean of type CollaborationEngineConfiguration. More info in Vaadin documentation.");
            }
            LOGGER.warn("Collaboration Engine is used in development/trial mode. Note that in order to make a production build, you need to obtain a license from Vaadin and configure the 'vaadin.ce.dataDir' property. You also need to provide a configuration object by using the static CollaborationEngine.configure() method in a VaadinServiceInitListener or, if using Spring/CDI, provide a bean of type CollaborationEngineConfiguration. More info in Vaadin documentation.");
            return CollaborationEngine.configure(vaadinService, new CollaborationEngineConfiguration(e -> {
                throw new IllegalStateException("License event handler was called in dev mode. This should not happen.");
            }), new CollaborationEngine(), false);
        });
    }

    public static CollaborationEngine configure(VaadinService vaadinService, CollaborationEngineConfiguration configuration) {
        return CollaborationEngine.configure(vaadinService, configuration, new CollaborationEngine(), true);
    }

    static CollaborationEngine configure(VaadinService vaadinService, CollaborationEngineConfiguration configuration, CollaborationEngine ce, boolean storeInService) {
        Objects.requireNonNull(vaadinService, "VaadinService cannot be null");
        Objects.requireNonNull(configuration, "Configuration cannot be null");
        if (vaadinService.getContext().getAttribute(CollaborationEngine.class) != null) {
            throw new IllegalStateException("Collaboration Engine has been already configured for the provided VaadinService. The configuration can be provided only once.");
        }
        configuration.setVaadinService(vaadinService);
        ce.configuration = configuration;
        if (storeInService) {
            vaadinService.getContext().setAttribute(CollaborationEngine.class, (Object)ce);
        }
        if (!vaadinService.getDeploymentConfiguration().isProductionMode()) {
            LicenseChecker.checkLicense((String)COLLABORATION_ENGINE_NAME, (String)COLLABORATION_ENGINE_VERSION);
        }
        return ce;
    }

    public TopicConnectionRegistration openTopicConnection(Component component, String topicId, UserInfo localUser, SerializableFunction<TopicConnection, Registration> connectionActivationCallback) {
        Objects.requireNonNull(component, "Connection context can't be null");
        ComponentConnectionContext context = new ComponentConnectionContext(component);
        return this.openTopicConnection(context, topicId, localUser, connectionActivationCallback);
    }

    public TopicConnectionRegistration openTopicConnection(ConnectionContext context, String topicId, UserInfo localUser, SerializableFunction<TopicConnection, Registration> connectionActivationCallback) {
        boolean hasSeat;
        Objects.requireNonNull(context, "Connection context can't be null");
        Objects.requireNonNull(topicId, "Topic id can't be null");
        Objects.requireNonNull(localUser, "User can't be null");
        Objects.requireNonNull(connectionActivationCallback, "Callback for connection activation can't be null");
        if (this.configuration == null) {
            throw new IllegalStateException("Collaboration Engine is missing required configuration that should be provided by a VaadinServiceInitListener. Collaboration Engine is supported only in a Vaadin application, where VaadinService initialization is expected to happen before usage.");
        }
        this.ensureConfigAndLicenseHandlerInitialization();
        if (this.configuration.isLicenseCheckingEnabled() && !(hasSeat = this.licenseHandler.registerUser(localUser.getId()))) {
            LOGGER.warn("Access for user '{}' was denied. The license may have expired or the user quota may have exceeded, check the license events handled by your LicenseEventHandler for more details.", (Object)localUser.getId());
            return new TopicConnectionRegistration(null, context);
        }
        Topic topic = this.topics.computeIfAbsent(topicId, id -> new Topic(this));
        TopicConnection connection = new TopicConnection(context, topic, localUser, isActive -> this.updateTopicActivation(topicId, (Boolean)isActive), connectionActivationCallback);
        return new TopicConnectionRegistration(connection, context);
    }

    public void requestAccess(UserInfo user, Consumer<AccessResponse> requestCallback) {
        UI ui = UI.getCurrent();
        if (ui == null) {
            throw new IllegalStateException("You are calling the requestAccess method without a UI instance being available. You can either move the call where you are sure a UI is defined or directly provide a ConnectionContext to the method. The current UI is automatically defined when processing requests to the server. In other cases, (e.g. from background threads), the current UI is not automatically defined.");
        }
        ComponentConnectionContext context = new ComponentConnectionContext((Component)ui);
        this.requestAccess(context, user, requestCallback);
    }

    public void requestAccess(ConnectionContext context, UserInfo user, Consumer<AccessResponse> requestCallback) {
        Objects.requireNonNull(context, "ConnectionContext cannot be null");
        Objects.requireNonNull(user, "UserInfo cannot be null");
        Objects.requireNonNull(requestCallback, "AccessResponse cannot be null");
        this.ensureConfigAndLicenseHandlerInitialization();
        boolean hasAccess = this.configuration.isLicenseCheckingEnabled() ? this.licenseHandler.registerUser(user.getId()) : true;
        AccessResponse response = new AccessResponse(hasAccess);
        context.dispatchAction((Command & Serializable)() -> requestCallback.accept(response));
    }

    public int getUserColorIndex(UserInfo userInfo) {
        int currentColorIndex = userInfo.getColorIndex();
        if (currentColorIndex != -1) {
            return currentColorIndex;
        }
        String userId = userInfo.getId();
        Integer colorIndex = this.userColors.computeIfAbsent(userId, id -> this.userColors.size() % 7);
        return colorIndex;
    }

    LicenseHandler getLicenseHandler() {
        return this.licenseHandler;
    }

    CollaborationEngineConfiguration getConfiguration() {
        return this.configuration;
    }

    Clock getClock() {
        return this.clock;
    }

    void setClock(Clock clock) {
        this.clock = clock;
    }

    private synchronized void ensureConfigAndLicenseHandlerInitialization() {
        if (this.licenseHandler == null) {
            this.licenseHandler = new LicenseHandler(this);
        }
    }

    Topic getTopic(String topicId) {
        return this.topics.get(topicId);
    }

    static {
        UsageStatistics.markAsUsed((String)COLLABORATION_ENGINE_NAME, (String)COLLABORATION_ENGINE_VERSION);
    }
}

