/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.collaborationengine.CollaborationBinder;
import com.vaadin.collaborationengine.CollaborationMap;
import com.vaadin.collaborationengine.JsonUtil;
import com.vaadin.collaborationengine.TopicConnection;
import com.vaadin.collaborationengine.UserInfo;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CollaborationBinderUtil {
    private static final String COLLABORATION_BINDER_MAP_NAME = CollaborationBinder.class.getName();
    private static final CollaborationBinder.FieldState EMPTY_FIELD_STATE = new CollaborationBinder.FieldState((JsonNode)NullNode.getInstance(), Collections.emptyList());

    private CollaborationBinderUtil() {
    }

    public static void setFieldValue(TopicConnection topicConnection, String propertyName, Object value) {
        Objects.requireNonNull(topicConnection, "Topic connection can't be null.");
        Objects.requireNonNull(propertyName, "Property name can't be null.");
        CollaborationBinderUtil.updateMapValue(topicConnection, propertyName, state -> CollaborationBinderUtil.withFieldValue(state, value));
    }

    public static void addEditor(TopicConnection topicConnection, String propertyName, UserInfo user) {
        CollaborationBinderUtil.addEditor(topicConnection, propertyName, user, 0);
    }

    public static void addEditor(TopicConnection topicConnection, String propertyName, UserInfo user, int fieldIndex) {
        Objects.requireNonNull(topicConnection, "Topic connection can't be null.");
        Objects.requireNonNull(propertyName, "Property name can't be null.");
        Objects.requireNonNull(user, "User can't be null.");
        CollaborationBinderUtil.updateMapValue(topicConnection, propertyName, jsonNode -> CollaborationBinderUtil.withEditors(jsonNode, editors -> Stream.concat(editors.filter(focusedEditor -> !focusedEditor.user.equals(user)), Stream.of(new CollaborationBinder.FocusedEditor(user, fieldIndex)))));
    }

    public static void removeEditor(TopicConnection topicConnection, String propertyName, UserInfo user) {
        Objects.requireNonNull(topicConnection, "Topic connection can't be null.");
        Objects.requireNonNull(propertyName, "Property name can't be null.");
        Objects.requireNonNull(user, "User can't be null.");
        CollaborationBinderUtil.updateMapValue(topicConnection, propertyName, jsonNode -> CollaborationBinderUtil.withEditors(jsonNode, editors -> editors.filter(editor -> !editor.user.equals(user))));
    }

    private static void updateMapValue(TopicConnection topicConnection, String propertyName, Function<ObjectNode, ObjectNode> updater) {
        CollaborationMap map = CollaborationBinderUtil.getMap(topicConnection);
        ObjectNode oldValue = map.get(propertyName, ObjectNode.class);
        JsonNode newValue = (JsonNode)updater.apply(oldValue);
        map.replace(propertyName, oldValue, newValue).thenAccept(success -> {
            if (!success.booleanValue()) {
                CollaborationBinderUtil.updateMapValue(topicConnection, propertyName, updater);
            }
        });
    }

    static CollaborationBinder.FieldState getFieldState(TopicConnection topic, String propertyName) {
        CollaborationBinder.FieldState fieldState = CollaborationBinderUtil.getMap(topic).get(propertyName, CollaborationBinder.FieldState.class);
        return fieldState == null ? EMPTY_FIELD_STATE : fieldState;
    }

    static CollaborationMap getMap(TopicConnection topic) {
        return topic.getNamedMap(COLLABORATION_BINDER_MAP_NAME);
    }

    private static ObjectNode withFieldValue(ObjectNode fieldState, Object newValue) {
        if (fieldState == null) {
            fieldState = (ObjectNode)JsonUtil.toJsonNode(EMPTY_FIELD_STATE);
        }
        ObjectNode jsonNode = fieldState.deepCopy();
        jsonNode.set("value", JsonUtil.toJsonNode(newValue));
        return jsonNode;
    }

    private static ObjectNode withEditors(ObjectNode fieldState, Function<Stream<CollaborationBinder.FocusedEditor>, Stream<CollaborationBinder.FocusedEditor>> updater) {
        if (fieldState == null) {
            fieldState = (ObjectNode)JsonUtil.toJsonNode(EMPTY_FIELD_STATE);
        }
        ObjectNode fieldStateNode = fieldState.deepCopy();
        List<CollaborationBinder.FocusedEditor> editors = JsonUtil.toInstance(fieldStateNode.get("editors"), JsonUtil.EDITORS_TYPE_REF);
        List newEditors = updater.apply(editors.stream()).collect(Collectors.toList());
        fieldStateNode.set("editors", JsonUtil.toJsonNode(newEditors));
        return fieldStateNode;
    }
}

