/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.ConnectionContext;
import com.vaadin.collaborationengine.TopicConnection;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Objects;

public class TopicConnectionRegistration
implements Registration {
    private TopicConnection topicConnection;
    private final ConnectionContext connectionContext;

    TopicConnectionRegistration(TopicConnection topicConnection, ConnectionContext connectionContext) {
        this.topicConnection = topicConnection;
        this.connectionContext = connectionContext;
    }

    public void remove() {
        if (this.topicConnection != null) {
            this.topicConnection.deactivateAndClose();
        }
    }

    public void onConnectionFailed(ConnectionFailedAction connectionFailedAction) {
        Objects.requireNonNull(connectionFailedAction, "The connection failed action can't be null");
        if (this.topicConnection == null) {
            ConnectionFailedEvent event = new ConnectionFailedEvent(this);
            this.connectionContext.dispatchAction((Command & Serializable)() -> connectionFailedAction.onConnectionFailed(event));
        }
    }

    public static class ConnectionFailedEvent
    extends EventObject {
        ConnectionFailedEvent(TopicConnectionRegistration source) {
            super(source);
        }

        @Override
        public TopicConnectionRegistration getSource() {
            return (TopicConnectionRegistration)super.getSource();
        }
    }

    @FunctionalInterface
    public static interface ConnectionFailedAction {
        public void onConnectionFailed(ConnectionFailedEvent var1);
    }
}

