/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.schedule.parse;

import com.fasterxml.jackson.core.JsonParser;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.schedule.model.BestTime;
import com.urbanairship.api.schedule.model.Schedule;
import java.io.IOException;
import org.joda.time.DateTime;

public final class ScheduleReader
implements JsonObjectReader<Schedule> {
    private final Schedule.Builder builder = Schedule.newBuilder();

    public void readScheduledTime(JsonParser jsonParser) throws IOException {
        this.builder.setScheduledTimestamp((DateTime)jsonParser.readValueAs(DateTime.class));
    }

    public void readBestTime(JsonParser jsonParser) throws IOException {
        this.builder.setBestTime((BestTime)jsonParser.readValueAs(BestTime.class));
    }

    @Override
    public Schedule validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage(), e);
        }
    }
}

