/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.ios;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.ios.IOSFields;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public class IOSTemplate
extends PushModelObject {
    private final Optional<String> templateId;
    private final Optional<IOSFields> iosFields;

    private IOSTemplate(Builder builder) {
        this.templateId = Optional.ofNullable(builder.templateId);
        this.iosFields = Optional.ofNullable(builder.iosFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="template_id")
    public Optional<String> getTemplateId() {
        return this.templateId;
    }

    @JsonProperty(value="fields")
    public Optional<IOSFields> getIosFields() {
        return this.iosFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IOSTemplate that = (IOSTemplate)o;
        return Objects.equal(this.templateId, that.templateId) && Objects.equal(this.iosFields, that.iosFields);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.templateId, this.iosFields});
    }

    public String toString() {
        return "IOSTemplate{templateId=" + this.templateId + ", iosFields=" + this.iosFields + '}';
    }

    @JsonPOJOBuilder(withPrefix="set")
    public static class Builder {
        String templateId = null;
        IOSFields iosFields = null;

        @JsonProperty(value="template_id")
        public Builder setTemplateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public Builder setFields(IOSFields iosFields) {
            this.iosFields = iosFields;
            return this;
        }

        public IOSTemplate build() {
            Preconditions.checkArgument((this.templateId == null || this.iosFields == null ? 1 : 0) != 0, (Object)"templateID and ios fields cannot both be set.");
            return new IOSTemplate(this);
        }
    }
}

