/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.actions;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.urbanairship.api.push.model.PushModelObject;
import java.net.URI;
import java.util.Optional;

public final class LandingPageContent
extends PushModelObject {
    private final Optional<Encoding> encoding;
    private final Optional<String> body;
    private final Optional<String> contentType;
    private final Optional<URI> url;
    public static final int MAX_BODY_SIZE_BYTES = 524288;
    public static final int MAX_BODY_SIZE_BASE64 = LandingPageContent.byteLengthBase64Encoded(524288);
    public static final int LARGE_BODY_SIZE_BYTES = 262144;
    public static final int LARGE_BODY_SIZE_BASE64 = LandingPageContent.byteLengthBase64Encoded(262144);
    public static final ImmutableSet<String> ALLOWED_CONTENT_TYPES = ImmutableSet.of((Object)"image/jpeg", (Object)"image/png", (Object)"image/gif", (Object)"image/tiff", (Object)"text/html", (Object)"text/plain", (Object[])new String[]{"application/json", "application/x-javascript", "text/javascript", "text/x-javascript", "text/x-json", "application/vnd.ms-excel", "application/msexcel", "application/x-msexcel", "application/x-ms-excel", "application/x-excel", "application/x-dos_ms_excel", "application/xls", "application/x-xls", "application/rtf", "application/x-rtf", "text/richtext", "application/pdf", "application/msexcel", "application/mspowerpoint", "application/msword", "application/vnd.apple.keynote", "application/vnd.apple.pages", "application/vnd.apple.numbers", "application/x-iwork-keynote-sffkey", "application/x-iwork-pages-sffpages", "application/x-iwork-numbers-sffnumbers"});

    private static int byteLengthBase64Encoded(int bytes) {
        return (int)Math.ceil((double)bytes / 3.0) * 4;
    }

    private LandingPageContent(Optional<String> contentType, Optional<Encoding> encoding, Optional<String> body, Optional<URI> url) {
        this.contentType = contentType;
        this.encoding = encoding;
        this.body = body;
        this.url = url;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return LandingPageContent.newBuilder().mergeFrom(this);
    }

    public Optional<String> getContentType() {
        return this.contentType;
    }

    public Optional<Encoding> getEncoding() {
        return this.encoding;
    }

    public Optional<String> getBody() {
        return this.body;
    }

    public Optional<URI> getUrl() {
        return this.url;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.encoding, this.body, this.contentType, this.url});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LandingPageContent other = (LandingPageContent)obj;
        return Objects.equal(this.encoding, other.encoding) && Objects.equal(this.body, other.body) && Objects.equal(this.contentType, other.contentType) && Objects.equal(this.url, other.url);
    }

    public String toString() {
        return "LandingPageContent{encoding=" + this.encoding + ", body='" + this.body + '\'' + ", contentType='" + this.contentType + '\'' + ", url='" + this.url + '\'' + '}';
    }

    public static final class Builder {
        private Optional<Encoding> encoding = Optional.empty();
        private Optional<String> body = Optional.empty();
        private Optional<String> contentType = Optional.empty();
        private Optional<URI> url = Optional.empty();

        private Builder() {
        }

        public Builder mergeFrom(LandingPageContent other) {
            this.encoding = other.getEncoding();
            return this.setBody(other.getBody().get()).setContentType(other.getContentType().get());
        }

        public Builder setEncoding(Encoding encoding) {
            this.encoding = Optional.of(encoding);
            return this;
        }

        public Builder setEncoding(Optional<Encoding> encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder setBody(String body) {
            this.body = Optional.of(body);
            return this;
        }

        public Builder setContentType(String contentType) {
            this.contentType = Optional.of(contentType);
            return this;
        }

        public Builder setUrl(URI url) {
            this.url = Optional.of(url);
            return this;
        }

        public LandingPageContent build() {
            if (!(this.url.isPresent() || this.body.isPresent() || this.contentType.isPresent())) {
                throw new RuntimeException("Content needs a body/contentType or an url.");
            }
            if (!this.url.isPresent() && this.body.isPresent() && !this.contentType.isPresent()) {
                throw new RuntimeException("Content needs a contentType.");
            }
            if (!this.url.isPresent() && !this.body.isPresent() && this.contentType.isPresent()) {
                throw new RuntimeException("Content needs a body.");
            }
            if (this.url.isPresent() && (this.body.isPresent() || this.contentType.isPresent() || this.encoding.isPresent())) {
                throw new RuntimeException("Content must only contain a body/contentType or an url.");
            }
            Preconditions.checkNotNull(this.encoding, (Object)"encoding should not be null.");
            return new LandingPageContent(this.contentType, this.encoding, this.body, this.url);
        }
    }

    public static enum Encoding {
        UTF8,
        Base64;

    }
}

