/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.localization;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.InApp;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.Notification;
import com.urbanairship.api.push.model.notification.richpush.RichPushMessage;
import java.util.Optional;

public class Localization
extends PushModelObject {
    private final Optional<String> country;
    private final Optional<String> language;
    private final Optional<InApp> inApp;
    private final Optional<RichPushMessage> richPushMessage;
    private final Optional<Notification> notification;

    private Localization(Builder builder) {
        this.country = Optional.ofNullable(builder.country);
        this.language = Optional.ofNullable(builder.language);
        this.inApp = Optional.ofNullable(builder.inApp);
        this.richPushMessage = Optional.ofNullable(builder.richPushMessage);
        this.notification = Optional.ofNullable(builder.notification);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<String> getCountry() {
        return this.country;
    }

    public Optional<String> getLanguage() {
        return this.language;
    }

    public Optional<InApp> getInApp() {
        return this.inApp;
    }

    public Optional<RichPushMessage> getRichPushMessage() {
        return this.richPushMessage;
    }

    public Optional<Notification> getNotification() {
        return this.notification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Localization that = (Localization)o;
        return Objects.equal(this.country, that.country) && Objects.equal(this.language, that.language) && Objects.equal(this.inApp, that.inApp) && Objects.equal(this.richPushMessage, that.richPushMessage) && Objects.equal(this.notification, that.notification);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.country, this.language, this.inApp, this.richPushMessage, this.notification});
    }

    public static class Builder {
        private String country;
        private String language;
        private Notification notification;
        private InApp inApp;
        private RichPushMessage richPushMessage;

        private Builder() {
        }

        public Builder setCountry(String country) {
            this.country = country;
            return this;
        }

        public Builder setLanguage(String language) {
            this.language = language;
            return this;
        }

        public Builder setNotification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public Builder setInApp(InApp inApp) {
            this.inApp = inApp;
            return this;
        }

        public Builder setRichPushMessage(RichPushMessage richPushMessage) {
            this.richPushMessage = richPushMessage;
            return this;
        }

        public Localization build() {
            Preconditions.checkArgument((this.language != null || this.country != null ? 1 : 0) != 0, (Object)"Language or country must be set.");
            return new Localization(this);
        }
    }
}

