/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.nameduser.model;

import com.google.common.base.Preconditions;
import com.urbanairship.api.nameduser.model.NamedUserUpdateDeviceType;
import java.util.Optional;

public class NamedUserUpdateChannel {
    private final Optional<NamedUserUpdateDeviceType> deviceType;
    private final Optional<String> channelId;
    private final Optional<String> emailAddress;

    private NamedUserUpdateChannel(Builder builder) {
        this.deviceType = Optional.ofNullable(builder.deviceType);
        this.channelId = Optional.ofNullable(builder.channelId);
        this.emailAddress = Optional.ofNullable(builder.emailAddress);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<NamedUserUpdateDeviceType> getDeviceType() {
        return this.deviceType;
    }

    public Optional<String> getChannelId() {
        return this.channelId;
    }

    public Optional<String> getEmailAddress() {
        return this.emailAddress;
    }

    public static class Builder {
        NamedUserUpdateDeviceType deviceType;
        String channelId;
        String emailAddress;

        public Builder addChannel(NamedUserUpdateDeviceType deviceType, String channelId) {
            this.deviceType = deviceType;
            this.channelId = channelId;
            return this;
        }

        public Builder addEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public NamedUserUpdateChannel build() {
            Preconditions.checkArgument((boolean)(this.channelId != null ^ this.emailAddress != null), (Object)"You can only add channel OR an email address");
            return new NamedUserUpdateChannel(this);
        }
    }
}

