/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.inbox;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.urbanairship.api.channel.parse.ChannelObjectMapper;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.inbox.model.InboxBatchDeleteResponse;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class InboxBatchDeleteRequest
implements Request<InboxBatchDeleteResponse> {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String API_INBOX_BATCH_DELETE = "/api/user/messages/batch-delete/";
    private final Map<String, List<String>> payload = new HashMap<String, List<String>>();

    private InboxBatchDeleteRequest(List<String> messageIds) {
        this.payload.put("message_ids", messageIds);
    }

    public static InboxBatchDeleteRequest newRequest(List<String> messageIds) {
        return new InboxBatchDeleteRequest(messageIds);
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        try {
            return ChannelObjectMapper.getInstance().writeValueAsString(this.payload);
        }
        catch (Exception ex) {
            return "{ \"exception\" : \"" + ex.getClass().getName() + "\", \"message\" : \"" + ex.getMessage() + "\" }";
        }
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, API_INBOX_BATCH_DELETE);
    }

    @Override
    public ResponseParser<InboxBatchDeleteResponse> getResponseParser() {
        return response -> (InboxBatchDeleteResponse)MAPPER.readValue(response, InboxBatchDeleteResponse.class);
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return false;
    }
}

