/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model.subscriptionlist;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.channel.model.ChannelAudience;
import com.urbanairship.api.channel.model.ChannelModelObject;
import com.urbanairship.api.channel.model.subscriptionlist.SubscriptionList;

public class SubscriptionListPayload
extends ChannelModelObject {
    private final ChannelAudience audience;
    ImmutableList<SubscriptionList> subscriptionList;

    private SubscriptionListPayload(ChannelAudience audience, ImmutableList<SubscriptionList> subscriptionList) {
        this.audience = audience;
        this.subscriptionList = subscriptionList;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public ChannelAudience getAudience() {
        return this.audience;
    }

    public ImmutableList<SubscriptionList> getSubscriptionList() {
        return this.subscriptionList;
    }

    public static class Builder {
        ChannelAudience audience;
        ImmutableList.Builder<SubscriptionList> subscriptionListBuilder = ImmutableList.builder();

        public Builder setAudience(ChannelAudience audience) {
            this.audience = audience;
            return this;
        }

        public Builder addSubscriptionList(SubscriptionList subscriptionList) {
            this.subscriptionListBuilder.add((Object)subscriptionList);
            return this;
        }

        public SubscriptionListPayload build() {
            ImmutableList subscriptionList = this.subscriptionListBuilder.build();
            Preconditions.checkNotNull((Object)this.audience, (Object)"Audience must be set.");
            Preconditions.checkArgument((subscriptionList.size() > 0 ? 1 : 0) != 0, (Object)"Subscription List must be added to SubscriptionListPayload.");
            return new SubscriptionListPayload(this.audience, subscriptionList);
        }
    }
}

