/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.segments.model;

import com.urbanairship.api.common.model.ErrorDetails;
import com.urbanairship.api.push.model.audience.Selector;
import java.util.Objects;

public class SegmentView {
    private final Selector criteria;
    private final String displayName;
    private final String error;
    private final ErrorDetails errorDetails;

    private SegmentView(Selector criteria, String displayName, String error, ErrorDetails errorDetails) {
        this.criteria = criteria;
        this.displayName = displayName;
        this.error = error;
        this.errorDetails = errorDetails;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Selector getCriteria() {
        return this.criteria;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getError() {
        return this.error;
    }

    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    public String toString() {
        return "SegmentView{criteria=" + this.criteria + ", displayName='" + this.displayName + '\'' + ", error='" + this.error + '\'' + ", errorDetails=" + this.errorDetails + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentView that = (SegmentView)o;
        return Objects.equals(this.criteria, that.criteria) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.error, that.error) && Objects.equals(this.errorDetails, that.errorDetails);
    }

    public int hashCode() {
        return Objects.hash(this.criteria, this.displayName, this.error, this.errorDetails);
    }

    public static final class Builder {
        private String displayName = null;
        private Selector criteria = null;
        private String error = null;
        private ErrorDetails errorDetails = null;

        private Builder() {
        }

        public Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder setCriteria(Selector criteria) {
            this.criteria = criteria;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setErrorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public SegmentView build() {
            return new SegmentView(this.criteria, this.displayName, this.error, this.errorDetails);
        }
    }
}

