/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.richpush;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.richpush.RichPushFields;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public class RichPushTemplate
extends PushModelObject {
    private final Optional<String> templateId;
    private final Optional<RichPushFields> richPushFields;

    private RichPushTemplate(Builder builder) {
        this.templateId = Optional.ofNullable(builder.templateId);
        this.richPushFields = Optional.ofNullable(builder.richPushFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="template_id")
    public Optional<String> getTemplateId() {
        return this.templateId;
    }

    @JsonProperty(value="fields")
    public Optional<RichPushFields> getRichPushFields() {
        return this.richPushFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RichPushTemplate that = (RichPushTemplate)o;
        return Objects.equal(this.templateId, that.templateId) && Objects.equal(this.richPushFields, that.richPushFields);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.templateId, this.richPushFields});
    }

    public String toString() {
        return "RichPushTemplate{templateId=" + this.templateId + ", richPushFields=" + this.richPushFields + '}';
    }

    @JsonPOJOBuilder(withPrefix="set")
    public static class Builder {
        String templateId = null;
        RichPushFields richPushFields = null;

        @JsonProperty(value="template_id")
        public Builder setTemplateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public Builder setFields(RichPushFields richPushFields) {
            this.richPushFields = richPushFields;
            return this;
        }

        public RichPushTemplate build() {
            Preconditions.checkArgument((this.templateId == null || this.richPushFields == null ? 1 : 0) != 0, (Object)"templateID and rich push fields cannot both be set.");
            return new RichPushTemplate(this);
        }
    }
}

