/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model;

import com.google.common.base.Objects;
import com.urbanairship.api.push.model.PushExpiry;
import com.urbanairship.api.push.model.PushModelObject;
import java.util.Optional;

public class PushOptions
extends PushModelObject {
    private final Optional<PushExpiry> expiry;
    private final Optional<Boolean> noThrottle;
    private final Optional<Boolean> personalization;

    private PushOptions(Builder builder) {
        this.expiry = Optional.ofNullable(builder.expiry);
        this.noThrottle = Optional.ofNullable(builder.noThrottle);
        this.personalization = Optional.ofNullable(builder.personalization);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<PushExpiry> getExpiry() {
        return this.expiry;
    }

    public Optional<Boolean> getNoThrottle() {
        return this.noThrottle;
    }

    public Optional<Boolean> getPersonalization() {
        return this.personalization;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.expiry, this.noThrottle, this.personalization});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PushOptions that = (PushOptions)o;
        return Objects.equal(this.expiry, that.expiry) && Objects.equal(this.noThrottle, that.noThrottle) && Objects.equal(this.personalization, that.personalization);
    }

    public String toString() {
        return "PushOptions{expiry=" + this.expiry + ", noThrottle=" + this.noThrottle + ", personalization=" + this.personalization + '}';
    }

    public static class Builder {
        private PushExpiry expiry = null;
        private Boolean noThrottle = null;
        private Boolean personalization = null;

        private Builder() {
        }

        public Builder setExpiry(PushExpiry value) {
            this.expiry = value;
            return this;
        }

        public Builder setNoThrottle(Boolean noThrottle) {
            this.noThrottle = noThrottle;
            return this;
        }

        public Builder setPersonalization(Boolean personalization) {
            this.personalization = personalization;
            return this;
        }

        public PushOptions build() {
            return new PushOptions(this);
        }
    }
}

