/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.templates;

import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.schedule.model.ScheduleResponse;
import com.urbanairship.api.schedule.parse.ScheduleObjectMapper;
import com.urbanairship.api.templates.model.TemplateScheduledPushPayload;
import com.urbanairship.api.templates.parse.TemplatesObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class TemplateScheduledPushRequest
implements Request<ScheduleResponse> {
    private static final String SCHEDULED_TEMPLATE_PUSH = "/api/templates/schedules/";
    private static final String TEMPLATE_PUSH_VALIDATE = "/api/templates/schedules/validate/";
    private List<TemplateScheduledPushPayload> scheduledTemplatePushPayloads = new ArrayList<TemplateScheduledPushPayload>();
    private boolean validateOnly = false;

    private TemplateScheduledPushRequest() {
    }

    public static TemplateScheduledPushRequest newRequest() {
        return new TemplateScheduledPushRequest();
    }

    public TemplateScheduledPushRequest addTemplateScheduledPushPayload(TemplateScheduledPushPayload templateScheduledPushPayload) {
        this.scheduledTemplatePushPayloads.add(templateScheduledPushPayload);
        return this;
    }

    public TemplateScheduledPushRequest addAllTemplatePushPayloads(List<TemplateScheduledPushPayload> scheduledTemplatePushPayload) {
        this.scheduledTemplatePushPayloads.addAll(scheduledTemplatePushPayload);
        return this;
    }

    public TemplateScheduledPushRequest setValidateOnly(boolean validateOnly) {
        this.validateOnly = validateOnly;
        return this;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        try {
            if (this.scheduledTemplatePushPayloads.size() == 1) {
                return TemplatesObjectMapper.getInstance().writeValueAsString((Object)this.scheduledTemplatePushPayloads.get(0));
            }
            return TemplatesObjectMapper.getInstance().writeValueAsString(this.scheduledTemplatePushPayloads);
        }
        catch (Exception ex) {
            return "{ \"exception\" : \"" + ex.getClass().getName() + "\", \"message\" : \"" + ex.getMessage() + "\" }";
        }
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) throws URISyntaxException {
        String path = this.validateOnly ? TEMPLATE_PUSH_VALIDATE : SCHEDULED_TEMPLATE_PUSH;
        return RequestUtils.resolveURI(baseUri, path);
    }

    @Override
    public ResponseParser<ScheduleResponse> getResponseParser() {
        return new ResponseParser<ScheduleResponse>(){

            @Override
            public ScheduleResponse parse(String response) throws IOException {
                return (ScheduleResponse)ScheduleObjectMapper.getInstance().readValue(response, ScheduleResponse.class);
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return false;
    }
}

