/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.tags.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import org.joda.time.DateTime;

public class TagListView {
    private final String name;
    private final Optional<String> description;
    private final Optional<ImmutableMap<String, String>> extras;
    private final Optional<ImmutableMap<String, ImmutableList<String>>> addTags;
    private final Optional<ImmutableMap<String, ImmutableList<String>>> removeTags;
    private final Optional<ImmutableMap<String, ImmutableList<String>>> setTags;
    private final DateTime created;
    private final DateTime lastUpdated;
    private final Integer channelCount;
    private final Integer mutationSuccessCount;
    private final Integer mutationErrorCount;
    private final String errorPath;
    private final String status;

    private TagListView(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="extra") ImmutableMap<String, String> extras, @JsonProperty(value="add") ImmutableMap<String, ImmutableList<String>> addTags, @JsonProperty(value="remove") ImmutableMap<String, ImmutableList<String>> removeTags, @JsonProperty(value="set") ImmutableMap<String, ImmutableList<String>> setTags, @JsonProperty(value="created") DateTime created, @JsonProperty(value="last_updated") DateTime lastUpdated, @JsonProperty(value="channel_count") Integer channelCount, @JsonProperty(value="mutation_success_count") Integer mutationSuccessCount, @JsonProperty(value="mutation_error_count") Integer mutationErrorCount, @JsonProperty(value="error_path") String errorPath, @JsonProperty(value="status") String status) {
        this.name = name;
        this.description = Optional.fromNullable((Object)description);
        this.extras = Optional.fromNullable(extras);
        this.addTags = Optional.fromNullable(addTags);
        this.removeTags = Optional.fromNullable(removeTags);
        this.setTags = Optional.fromNullable(setTags);
        this.created = created;
        this.lastUpdated = lastUpdated;
        this.channelCount = channelCount;
        this.mutationSuccessCount = mutationSuccessCount;
        this.mutationErrorCount = mutationErrorCount;
        this.errorPath = errorPath;
        this.status = status;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public Optional<ImmutableMap<String, String>> getExtras() {
        return this.extras;
    }

    public Optional<ImmutableMap<String, ImmutableList<String>>> getAddTags() {
        return this.addTags;
    }

    public Optional<ImmutableMap<String, ImmutableList<String>>> getRemoveTags() {
        return this.removeTags;
    }

    public Optional<ImmutableMap<String, ImmutableList<String>>> getSetTags() {
        return this.setTags;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public DateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public Integer getChannelCount() {
        return this.channelCount;
    }

    public Integer getmutationSuccessCount() {
        return this.mutationSuccessCount;
    }

    public Integer getMutationErrorCount() {
        return this.mutationErrorCount;
    }

    public String getErrorPath() {
        return this.errorPath;
    }

    public String getStatus() {
        return this.status;
    }

    public String toString() {
        return "TagListView{name='" + this.name + '\'' + ", description=" + this.description + ", extras=" + this.extras + ", addTags=" + this.addTags + ", removeTags=" + this.removeTags + ", setTags=" + this.setTags + ", created=" + this.created + ", lastUpdated=" + this.lastUpdated + ", channelCount=" + this.channelCount + ", mutationSuccessCount=" + this.mutationSuccessCount + ", mutationErrorCount=" + this.mutationErrorCount + ", errorPath=" + this.errorPath + ", status=" + this.status + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.description, this.extras, this.addTags, this.removeTags, this.setTags, this.created, this.lastUpdated, this.channelCount, this.mutationSuccessCount, this.mutationErrorCount, this.status});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TagListView other = (TagListView)obj;
        return Objects.equal((Object)this.name, (Object)other.name) && Objects.equal(this.description, other.description) && Objects.equal(this.extras, other.extras) && Objects.equal(this.addTags, other.addTags) && Objects.equal(this.removeTags, other.removeTags) && Objects.equal(this.setTags, other.setTags) && Objects.equal((Object)this.created, (Object)other.created) && Objects.equal((Object)this.lastUpdated, (Object)other.lastUpdated) && Objects.equal((Object)this.channelCount, (Object)other.channelCount) && Objects.equal((Object)this.mutationSuccessCount, (Object)other.mutationSuccessCount) && Objects.equal((Object)this.mutationErrorCount, (Object)other.mutationErrorCount) && Objects.equal((Object)this.errorPath, (Object)other.errorPath) && Objects.equal((Object)this.status, (Object)other.status);
    }

    public static final class Builder {
        private String name = null;
        private String description = null;
        private ImmutableMap.Builder<String, String> extras = ImmutableMap.builder();
        private ImmutableMap.Builder<String, ImmutableList<String>> addTags = ImmutableMap.builder();
        private ImmutableMap.Builder<String, ImmutableList<String>> removeTags = ImmutableMap.builder();
        private ImmutableMap.Builder<String, ImmutableList<String>> setTags = ImmutableMap.builder();
        private DateTime created = null;
        private DateTime lastUpdated = null;
        private Integer channelCount = null;
        private Integer mutationSuccessCount = null;
        private Integer mutationErrorCount = null;
        private String errorPath = null;
        private String status = null;

        private Builder() {
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setCreated(DateTime created) {
            this.created = created;
            return this;
        }

        public Builder setLastUpdated(DateTime lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public Builder setChannelCount(int channelCount) {
            this.channelCount = channelCount;
            return this;
        }

        public Builder setMutationSuccessCount(int mutationSuccessCount) {
            this.mutationSuccessCount = mutationSuccessCount;
            return this;
        }

        public Builder setMutationErrorCount(int mutationErrorCount) {
            this.mutationErrorCount = mutationErrorCount;
            return this;
        }

        public Builder setErrorPath(String errorPath) {
            this.errorPath = errorPath;
            return this;
        }

        public Builder setStatus(String status) {
            this.status = status;
            return this;
        }

        public Builder addExtra(String key, String val) {
            this.extras.put((Object)key, (Object)val);
            return this;
        }

        public Builder addAllExtras(ImmutableMap<String, String> extras) {
            if (!extras.isEmpty()) {
                this.extras.putAll(extras);
            }
            return this;
        }

        public Builder addAddTags(ImmutableMap<String, ImmutableList<String>> addTags) {
            if (!addTags.isEmpty()) {
                this.addTags.putAll(addTags);
            }
            return this;
        }

        public Builder addRemoveTags(ImmutableMap<String, ImmutableList<String>> removeTags) {
            if (!removeTags.isEmpty()) {
                this.removeTags.putAll(removeTags);
            }
            return this;
        }

        public Builder addSetTags(ImmutableMap<String, ImmutableList<String>> setTags) {
            if (!setTags.isEmpty()) {
                this.setTags.putAll(setTags);
            }
            return this;
        }

        public TagListView build() {
            return new TagListView(this.name, this.description, this.extras.build(), this.addTags.build(), this.removeTags.build(), this.setTags.build(), this.created, this.lastUpdated, this.channelCount, this.mutationSuccessCount, this.mutationErrorCount, this.errorPath, this.status);
        }
    }
}

