/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.sms.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class MmsSlides {
    private final Optional<String> text;
    private final String mediaUrl;
    private final String mediaContentType;
    private final Optional<Integer> mediaContentLength;

    protected MmsSlides(Builder builder) {
        this.text = Optional.fromNullable((Object)builder.text);
        this.mediaUrl = builder.mediaUrl;
        this.mediaContentType = builder.mediaContentType;
        this.mediaContentLength = Optional.fromNullable((Object)builder.mediaContentLength);
    }

    public Optional<String> getText() {
        return this.text;
    }

    public String getMediaUrl() {
        return this.mediaUrl;
    }

    public String getMediaContentType() {
        return this.mediaContentType;
    }

    public Optional<Integer> getMediaContentLength() {
        return this.mediaContentLength;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MmsSlides that = (MmsSlides)o;
        return this.text == that.text && Objects.equal((Object)this.mediaUrl, (Object)that.mediaUrl) && Objects.equal((Object)this.mediaContentType, (Object)that.mediaContentType) && Objects.equal(this.mediaContentLength, that.mediaContentLength);
    }

    public String toString() {
        return "MmsSlides{text=" + this.text + ", mediaUrl=" + this.mediaUrl + ", mediaContentType=" + this.mediaContentType + ", mediaContentLength=" + this.mediaContentLength + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.text, this.mediaUrl, this.mediaContentType, this.mediaContentLength});
    }

    public static final class Builder {
        private String text;
        private String mediaUrl;
        private String mediaContentType;
        private Integer mediaContentLength;

        protected Builder() {
        }

        public Builder setText(String text) {
            this.text = text;
            return this;
        }

        public Builder setMediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
            return this;
        }

        public Builder setMediaContentType(String mediaContentType) {
            this.mediaContentType = mediaContentType;
            return this;
        }

        public Builder setMediaContentLength(Integer mediaContentLength) {
            this.mediaContentLength = mediaContentLength;
            return this;
        }

        public MmsSlides build() {
            Preconditions.checkNotNull((Object)this.mediaUrl, (Object)"mediaUrl cannot be null.");
            Preconditions.checkNotNull((Object)this.mediaContentType, (Object)"mediaContentType cannot be null.");
            return new MmsSlides(this);
        }
    }
}

