/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse;

import com.fasterxml.jackson.core.JsonParser;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.push.model.DeviceTypeData;
import com.urbanairship.api.push.model.InApp;
import com.urbanairship.api.push.model.PushOptions;
import com.urbanairship.api.push.model.PushPayload;
import com.urbanairship.api.push.model.audience.Selector;
import com.urbanairship.api.push.model.notification.Notification;
import com.urbanairship.api.push.model.notification.richpush.RichPushMessage;
import java.io.IOException;

public class PushPayloadReader
implements JsonObjectReader<PushPayload> {
    private final PushPayload.Builder builder = PushPayload.newBuilder();

    public void readAudience(JsonParser jsonParser) throws IOException {
        this.builder.setAudience((Selector)jsonParser.readValueAs(Selector.class));
    }

    public void readNotification(JsonParser jsonParser) throws IOException {
        this.builder.setNotification((Notification)jsonParser.readValueAs(Notification.class));
    }

    public void readMessage(JsonParser jsonParser) throws IOException {
        this.builder.setMessage((RichPushMessage)jsonParser.readValueAs(RichPushMessage.class));
    }

    public void readOptions(JsonParser parser) throws IOException {
        this.builder.setPushOptions((PushOptions)parser.readValueAs(PushOptions.class));
    }

    public void readDeviceTypes(JsonParser parser) throws IOException {
        this.builder.setDeviceTypes((DeviceTypeData)parser.readValueAs(DeviceTypeData.class));
    }

    public void readInApp(JsonParser parser) throws IOException {
        this.builder.setInApp((InApp)parser.readValueAs(InApp.class));
    }

    @Override
    public PushPayload validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage());
        }
    }
}

