/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.urbanairship.api.push.model.DeviceType;
import com.urbanairship.api.push.model.PushModelObject;

public final class DeviceTypeData
extends PushModelObject {
    private final Optional<ImmutableSet<DeviceType>> deviceTypes;

    private DeviceTypeData(Optional<ImmutableSet<DeviceType>> deviceTypes) {
        this.deviceTypes = deviceTypes;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static DeviceTypeData of(DeviceType ... deviceTypes) {
        Builder builder = DeviceTypeData.newBuilder();
        for (DeviceType p : deviceTypes) {
            builder.addDeviceType(p);
        }
        return builder.build();
    }

    public Optional<ImmutableSet<DeviceType>> getDeviceTypes() {
        return this.deviceTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceTypeData that = (DeviceTypeData)o;
        return Objects.equal(this.deviceTypes, that.deviceTypes);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.deviceTypes});
    }

    public String toString() {
        return "DeviceTypeData{deviceTypes=" + this.deviceTypes + '}';
    }

    public static class Builder {
        private ImmutableSet.Builder<DeviceType> deviceTypes = null;

        private Builder() {
        }

        public Builder addDeviceType(DeviceType deviceType) {
            if (this.deviceTypes == null) {
                this.deviceTypes = ImmutableSet.builder();
            }
            this.deviceTypes.add((Object)deviceType);
            return this;
        }

        public Builder addAllDeviceTypes(Iterable<DeviceType> deviceTypes) {
            if (this.deviceTypes == null) {
                this.deviceTypes = ImmutableSet.builder();
            }
            this.deviceTypes.addAll(deviceTypes);
            return this;
        }

        public DeviceTypeData build() {
            return new DeviceTypeData(this.deviceTypes == null ? Optional.absent() : Optional.fromNullable((Object)this.deviceTypes.build()));
        }
    }
}

