/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.experiments;

import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.experiments.model.Experiment;
import com.urbanairship.api.experiments.model.ExperimentResponse;
import com.urbanairship.api.experiments.parse.ExperimentObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class ExperimentRequest
implements Request<ExperimentResponse> {
    private static final String EXPERIMENT_PATH = "/api/experiments/";
    private static final String EXPERIMENT_VALIDATE_PATH = "/api/experiments/validate/";
    private final Experiment experiment;
    private boolean validateOnly;

    private ExperimentRequest(Experiment experiment) {
        Preconditions.checkNotNull((Object)experiment, (Object)"Experiment payload required when creating a push request");
        this.experiment = experiment;
    }

    public static ExperimentRequest newRequest(Experiment experiment) {
        return new ExperimentRequest(experiment);
    }

    public ExperimentRequest setValidateOnly(boolean validateOnly) {
        this.validateOnly = validateOnly;
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        return this.experiment.toJSON();
    }

    @Override
    public URI getUri(URI baseUri) {
        String path = this.validateOnly ? EXPERIMENT_VALIDATE_PATH : EXPERIMENT_PATH;
        return RequestUtils.resolveURI(baseUri, path);
    }

    @Override
    public ResponseParser<ExperimentResponse> getResponseParser() {
        return new ResponseParser<ExperimentResponse>(){

            @Override
            public ExperimentResponse parse(String response) throws IOException {
                return (ExperimentResponse)ExperimentObjectMapper.getInstance().readValue(response, ExperimentResponse.class);
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return false;
    }
}

