/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.customevents.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.urbanairship.api.common.model.ErrorDetails;

public class CustomEventResponse {
    private final Optional<String> operationId;
    private final boolean ok;
    private final Optional<String> error;
    private final Optional<ErrorDetails> errorDetails;

    public CustomEventResponse(String operationId, boolean ok, String error, ErrorDetails errorDetails) {
        this.operationId = Optional.fromNullable((Object)operationId);
        this.ok = ok;
        this.error = Optional.fromNullable((Object)error);
        this.errorDetails = Optional.fromNullable((Object)errorDetails);
    }

    public Optional<String> getOperationId() {
        return this.operationId;
    }

    public boolean isOk() {
        return this.ok;
    }

    public Optional<String> getError() {
        return this.error;
    }

    public Optional<ErrorDetails> getErrorDetails() {
        return this.errorDetails;
    }

    public String toString() {
        return "CustomEventResponse{operationId=" + this.operationId + ", ok=" + this.ok + ", error=" + this.error + ", errorDetails=" + this.errorDetails + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomEventResponse that = (CustomEventResponse)o;
        return this.ok == that.ok && Objects.equal(this.operationId, that.operationId) && Objects.equal(this.error, that.error) && Objects.equal(this.errorDetails, that.errorDetails);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.operationId, this.ok, this.error, this.errorDetails});
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String operationId;
        private boolean ok = false;
        private String error = null;
        private ErrorDetails errorDetails = null;

        private Builder() {
        }

        public Builder addOperationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public Builder setOk(boolean ok) {
            this.ok = ok;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setErrorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public CustomEventResponse build() {
            return new CustomEventResponse(this.operationId, this.ok, this.error, this.errorDetails);
        }
    }
}

