/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.createandsend.model.notification.sms;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.urbanairship.api.createandsend.model.notification.sms.SmsTemplate;
import com.urbanairship.api.push.model.DeviceType;
import com.urbanairship.api.push.model.PushExpiry;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.DevicePayloadOverride;

public class SmsPayload
extends PushModelObject
implements DevicePayloadOverride {
    private final Optional<String> alert;
    private final Optional<PushExpiry> pushExpiry;
    private final Optional<SmsTemplate> smsTemplate;
    private final DeviceType deviceType = DeviceType.SMS;

    private SmsPayload(Builder builder) {
        this.alert = Optional.fromNullable((Object)builder.alert);
        this.pushExpiry = Optional.fromNullable((Object)builder.pushExpiry);
        this.smsTemplate = Optional.fromNullable((Object)builder.smsTemplate);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    @Override
    public Optional<String> getAlert() {
        return this.alert;
    }

    public Optional<PushExpiry> getPushExpiry() {
        return this.pushExpiry;
    }

    public Optional<SmsTemplate> getSmsTemplate() {
        return this.smsTemplate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmsPayload that = (SmsPayload)o;
        return Objects.equal(this.alert, that.alert) && Objects.equal(this.pushExpiry, that.pushExpiry) && Objects.equal(this.smsTemplate, that.smsTemplate);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.alert, this.pushExpiry, this.smsTemplate});
    }

    public String toString() {
        return "SmsPayload{alert=" + this.alert + ", pushExpiry=" + this.pushExpiry + ", smsTemplate=" + this.smsTemplate + '}';
    }

    public static class Builder {
        private String alert = null;
        private PushExpiry pushExpiry = null;
        private SmsTemplate smsTemplate = null;

        public Builder setAlert(String alert) {
            this.alert = alert;
            return this;
        }

        public Builder setPushExpiry(PushExpiry pushExpiry) {
            this.pushExpiry = pushExpiry;
            return this;
        }

        public Builder setSmsTemplate(SmsTemplate smsTemplate) {
            this.smsTemplate = smsTemplate;
            return this;
        }

        public SmsPayload build() {
            Preconditions.checkArgument((this.alert == null || this.smsTemplate == null ? 1 : 0) != 0, (Object)"both alert and sms template cannot be set.");
            return new SmsPayload(this);
        }
    }
}

