/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.parse.open;

import com.fasterxml.jackson.core.JsonParser;
import com.urbanairship.api.channel.model.open.OpenChannel;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.common.parse.MapOfStringsDeserializer;
import com.urbanairship.api.common.parse.StringFieldDeserializer;
import java.io.IOException;

public class OpenChannelReader
implements JsonObjectReader<OpenChannel> {
    private final OpenChannel.Builder builder = OpenChannel.newBuilder();

    public void readPlatformName(JsonParser parser) throws IOException {
        this.builder.setOpenPlatformName(StringFieldDeserializer.INSTANCE.deserialize(parser, "open_platform_name"));
    }

    public void readOldAddress(JsonParser parser) throws IOException {
        this.builder.setOldAddress(StringFieldDeserializer.INSTANCE.deserialize(parser, "old_address"));
    }

    public void readIdentifiers(JsonParser parser) throws IOException {
        this.builder.addAllIdentifierEntries(MapOfStringsDeserializer.INSTANCE.deserialize(parser, "identifiers"));
    }

    @Override
    public OpenChannel validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage());
        }
    }
}

