/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model.email;

import com.google.common.base.Preconditions;
import com.urbanairship.api.channel.model.email.EmailChannelResponse;
import com.urbanairship.api.channel.model.email.UpdateEmailChannel;
import com.urbanairship.api.channel.parse.ChannelObjectMapper;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class UpdateEmailChannelRequest
implements Request<EmailChannelResponse> {
    private static final String API_UPDATE_EMAIL_CHANNEL = "/api/channels/email/";
    private final String path;
    private final UpdateEmailChannel payload;

    private UpdateEmailChannelRequest(String path, UpdateEmailChannel payload) {
        this.path = path;
        this.payload = payload;
    }

    public static UpdateEmailChannelRequest newRequest(String channelId, UpdateEmailChannel payload) {
        Preconditions.checkNotNull((Object)payload, (Object)"Payload must not be null to create an UpdateEmail channel request");
        Preconditions.checkNotNull((Object)channelId, (Object)"ChannelId must not be null to create an UpdateEmail channel request");
        return new UpdateEmailChannelRequest(API_UPDATE_EMAIL_CHANNEL + channelId, payload);
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.PUT;
    }

    @Override
    public String getRequestBody() {
        return this.payload.toJSON();
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) throws URISyntaxException {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<EmailChannelResponse> getResponseParser() {
        return new ResponseParser<EmailChannelResponse>(){

            @Override
            public EmailChannelResponse parse(String response) throws IOException {
                return (EmailChannelResponse)ChannelObjectMapper.getInstance().readValue(response, EmailChannelResponse.class);
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

