/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model.email;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.urbanairship.api.common.model.ErrorDetails;

public final class EmailChannelResponse {
    private final boolean ok;
    private final Optional<String> channelId;
    private final Optional<String> error;
    private final Optional<ErrorDetails> errorDetails;

    private EmailChannelResponse(Builder builder) {
        this.ok = builder.ok;
        this.channelId = Optional.fromNullable((Object)builder.channelId);
        this.error = Optional.fromNullable((Object)builder.error);
        this.errorDetails = Optional.fromNullable((Object)builder.errorDetails);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean getOk() {
        return this.ok;
    }

    public Optional<String> getChannelId() {
        return this.channelId;
    }

    public Optional<String> getError() {
        return this.error;
    }

    public Optional<ErrorDetails> getErrorDetails() {
        return this.errorDetails;
    }

    public String toString() {
        return "EmailChannelResponse{ok=" + this.ok + ", channelId=" + this.channelId + ", error=" + this.error + ", errorDetails=" + this.errorDetails + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ok, this.channelId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EmailChannelResponse other = (EmailChannelResponse)obj;
        return Objects.equal((Object)this.ok, (Object)other.ok) && Objects.equal(this.channelId, other.channelId) && Objects.equal(this.error, other.error) && Objects.equal(this.errorDetails, other.errorDetails);
    }

    public static class Builder {
        private boolean ok;
        private String channelId = null;
        private String error = null;
        private ErrorDetails errorDetails = null;

        private Builder() {
        }

        public Builder setOk(boolean value) {
            this.ok = value;
            return this;
        }

        public Builder setChannelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setErrorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public EmailChannelResponse build() {
            return new EmailChannelResponse(this);
        }
    }
}

