/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.urbanairship.api.common.model.ErrorDetails;

public class OpenChannelResponse {
    private final boolean ok;
    private final String channelId;
    private final Optional<String> error;
    private final Optional<ErrorDetails> errorDetails;

    private OpenChannelResponse(Builder builder) {
        this.ok = builder.ok;
        this.channelId = builder.channel_id;
        this.error = Optional.fromNullable((Object)builder.error);
        this.errorDetails = Optional.fromNullable((Object)builder.errorDetails);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean getOk() {
        return this.ok;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public Optional<String> getError() {
        return this.error;
    }

    public Optional<ErrorDetails> getErrorDetails() {
        return this.errorDetails;
    }

    public String toString() {
        return "OpenChannelResponse{ok=" + this.ok + ", channelId='" + this.channelId + ", error=" + this.error + ", errorDetails=" + this.errorDetails + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenChannelResponse that = (OpenChannelResponse)o;
        return this.ok == that.ok && Objects.equal((Object)this.channelId, (Object)that.channelId) && Objects.equal(this.error, that.error) && Objects.equal(this.errorDetails, that.errorDetails);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ok, this.channelId, this.error, this.errorDetails});
    }

    public static class Builder {
        private boolean ok;
        private String channel_id;
        private String error;
        private ErrorDetails errorDetails;

        public Builder setOk(boolean ok) {
            this.ok = ok;
            return this;
        }

        public Builder setChannelId(String channel_id) {
            this.channel_id = channel_id;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setErrorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public OpenChannelResponse build() {
            return new OpenChannelResponse(this);
        }
    }
}

