/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import com.urbanairship.api.channel.model.SmsRegistrationResponse;
import com.urbanairship.api.channel.parse.ChannelObjectMapper;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.common.parse.DateFormats;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class SmsRegistrationRequest
implements Request<SmsRegistrationResponse> {
    private static final String REGISTER_SMS_CHANNEL = "/api/channels/sms";
    private static final String OPT_OUT = "/api/channels/sms/opt-out";
    private static final String UNINSTALL = "/api/channels/sms/uninstall";
    private static final String SENDER_KEY = "sender";
    private static final String MSISDN_KEY = "msisdn";
    private static final String OPTED_IN_KEY = "opted_in";
    private final String path;
    private final Map<String, String> payload = new HashMap<String, String>();

    private SmsRegistrationRequest(String path, String sender, String msisdn) {
        this.path = path;
        this.payload.put(SENDER_KEY, sender);
        this.payload.put(MSISDN_KEY, msisdn);
    }

    private SmsRegistrationRequest(String path, String sender, String msisdn, DateTime optedIn) {
        this.path = path;
        this.payload.put(SENDER_KEY, sender);
        this.payload.put(MSISDN_KEY, msisdn);
        this.payload.put(OPTED_IN_KEY, DateFormats.DATE_FORMATTER.print((ReadableInstant)optedIn));
    }

    public static SmsRegistrationRequest newOptOutRequest(String sender, String msisdn) {
        return new SmsRegistrationRequest(OPT_OUT, sender, msisdn);
    }

    public static SmsRegistrationRequest newUninstallRequest(String sender, String msisdn) {
        return new SmsRegistrationRequest(UNINSTALL, sender, msisdn);
    }

    public static SmsRegistrationRequest newRegistrationRequest(String sender, String msisdn) {
        return new SmsRegistrationRequest(REGISTER_SMS_CHANNEL, sender, msisdn);
    }

    public static SmsRegistrationRequest newRegistrationRequest(String sender, String msisdn, DateTime optedIn) {
        return new SmsRegistrationRequest(REGISTER_SMS_CHANNEL, sender, msisdn, optedIn);
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        Preconditions.checkArgument((!this.payload.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((this.payload.containsKey(SENDER_KEY) && this.payload.containsKey(MSISDN_KEY) ? 1 : 0) != 0, (Object)"Sender and msisdn are required for opt-out, registration, and uninstall requests.");
        try {
            return ChannelObjectMapper.getInstance().writeValueAsString(this.payload);
        }
        catch (JsonProcessingException e) {
            return "{ \"exception\" : \"" + ((Object)((Object)e)).getClass().getName() + "\", \"message\" : \"" + e.getMessage() + "\" }";
        }
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) throws URISyntaxException {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<SmsRegistrationResponse> getResponseParser() {
        return new ResponseParser<SmsRegistrationResponse>(){

            @Override
            public SmsRegistrationResponse parse(String response) throws IOException {
                return (SmsRegistrationResponse)ChannelObjectMapper.getInstance().readValue(response, SmsRegistrationResponse.class);
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

