/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.urbanairship.api.channel.model.ChannelAttributesResponse;
import com.urbanairship.api.channel.model.attributes.ChannelAttributesPayload;
import com.urbanairship.api.channel.parse.ChannelObjectMapper;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class ChannelAttributesRequest
implements Request<ChannelAttributesResponse> {
    private final ObjectMapper MAPPER = ChannelObjectMapper.getInstance();
    private static final String API_CHANNELS_ATTRIBUTES = "/api/channels/attributes";
    private final String path;
    private final ChannelAttributesPayload payload;

    private ChannelAttributesRequest(String path, ChannelAttributesPayload payload) {
        this.path = path;
        this.payload = payload;
    }

    public static ChannelAttributesRequest newRequest(ChannelAttributesPayload payload) {
        return new ChannelAttributesRequest(API_CHANNELS_ATTRIBUTES, payload);
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        return this.payload.toJSON();
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<ChannelAttributesResponse> getResponseParser() {
        return new ResponseParser<ChannelAttributesResponse>(){

            @Override
            public ChannelAttributesResponse parse(String response) throws IOException {
                return (ChannelAttributesResponse)ChannelAttributesRequest.this.MAPPER.readValue(response, ChannelAttributesResponse.class);
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

