/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.segments.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.segments.model.SegmentListingView;

public class SegmentListingResponse {
    private final Optional<String> nextPage;
    private final ImmutableList<SegmentListingView> segmentListingViews;

    private SegmentListingResponse(String nextPage, ImmutableList<SegmentListingView> segmentListingViews) {
        this.nextPage = Optional.fromNullable((Object)nextPage);
        this.segmentListingViews = segmentListingViews;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<String> getNextPage() {
        return this.nextPage;
    }

    public ImmutableList<SegmentListingView> getSegmentListingViews() {
        return this.segmentListingViews;
    }

    public String toString() {
        return "SegmentListingResponse{nextPage=" + this.nextPage + ", segments=" + this.segmentListingViews + "}";
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.nextPage, this.segmentListingViews});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SegmentListingResponse other = (SegmentListingResponse)obj;
        return Objects.equal(this.nextPage, other.nextPage) && Objects.equal(this.segmentListingViews, other.segmentListingViews);
    }

    public static final class Builder {
        private String nextPage = null;
        private ImmutableList.Builder<SegmentListingView> segmentObjects = ImmutableList.builder();

        private Builder() {
        }

        public Builder setNextPage(String nextPage) {
            this.nextPage = nextPage;
            return this;
        }

        public Builder addSegmentObject(SegmentListingView value) {
            this.segmentObjects.add((Object)value);
            return this;
        }

        public Builder addAllSegmentObjects(Iterable<? extends SegmentListingView> value) {
            this.segmentObjects.addAll(value);
            return this;
        }

        public SegmentListingResponse build() {
            return new SegmentListingResponse(this.nextPage, this.segmentObjects.build());
        }
    }
}

