/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.schedule.parse;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.schedule.model.SchedulePayload;
import com.urbanairship.api.schedule.model.ScheduleResponse;
import java.io.IOException;
import java.util.List;

public final class ScheduleResponseReader
implements JsonObjectReader<ScheduleResponse> {
    private final ScheduleResponse.Builder builder = ScheduleResponse.newBuilder();

    public void readOk(JsonParser jsonParser) throws IOException {
        this.builder.setOk(jsonParser.getBooleanValue());
    }

    public void readOperationId(JsonParser jsonParser) throws IOException {
        this.builder.setOperationId((String)jsonParser.readValueAs(String.class));
    }

    public void readScheduleUrls(JsonParser jsonParser) throws IOException {
        List list = (List)jsonParser.readValueAs((TypeReference)new TypeReference<List<String>>(){});
        this.builder.addAllScheduleUrls(list);
    }

    public void readScheduleIds(JsonParser jsonParser) throws IOException {
        List list = (List)jsonParser.readValueAs((TypeReference)new TypeReference<List<String>>(){});
        this.builder.addAllScheduleIds(list);
    }

    public void readSchedulePayloads(JsonParser jsonParser) throws IOException {
        this.builder.addAllSchedulePayload((List)jsonParser.readValueAs((TypeReference)new TypeReference<List<SchedulePayload>>(){}));
    }

    @Override
    public ScheduleResponse validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception ex) {
            throw new APIParsingException(ex.getMessage());
        }
    }
}

