/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.reports.model.PushInfoResponse;

public class PushListingResponse {
    private final Optional<String> nextPage;
    private final Optional<ImmutableList<PushInfoResponse>> pushInfoObjects;

    private PushListingResponse() {
        this(null, null);
    }

    private PushListingResponse(String nextPage, Optional<ImmutableList<PushInfoResponse>> pushInfoObjects) {
        this.nextPage = Optional.fromNullable((Object)nextPage);
        this.pushInfoObjects = pushInfoObjects;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<String> getNextPage() {
        return this.nextPage;
    }

    public Optional<ImmutableList<PushInfoResponse>> getPushInfoList() {
        return this.pushInfoObjects;
    }

    public String toString() {
        return "PushInfoResponse{nextPage='" + this.nextPage + '\'' + ", pushInfoObjects =" + this.pushInfoObjects + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.nextPage, this.pushInfoObjects});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PushListingResponse other = (PushListingResponse)obj;
        return Objects.equal(this.nextPage, other.nextPage) && Objects.equal(this.pushInfoObjects, other.pushInfoObjects);
    }

    public static class Builder {
        private String nextPage = null;
        private ImmutableList.Builder<PushInfoResponse> pushInfoObjects = ImmutableList.builder();

        private Builder() {
        }

        public Builder setNextPage(String value) {
            this.nextPage = value;
            return this;
        }

        public Builder addPushInfoObject(PushInfoResponse value) {
            this.pushInfoObjects.add((Object)value);
            return this;
        }

        public Builder addPushInfoObjects(Iterable<? extends PushInfoResponse> value) {
            this.pushInfoObjects.addAll(value);
            return this;
        }

        public PushListingResponse build() {
            return new PushListingResponse(this.nextPage, Optional.fromNullable((Object)this.pushInfoObjects.build()));
        }
    }
}

