/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.wns;

import com.google.common.base.Optional;

public class WNSBadgeData {
    private final Optional<Integer> value;
    private final Optional<Glyph> glyph;

    private WNSBadgeData(Optional<Integer> value, Optional<Glyph> glyph) {
        this.value = value;
        this.glyph = glyph;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<Integer> getValue() {
        return this.value;
    }

    public Optional<Glyph> getGlyph() {
        return this.glyph;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WNSBadgeData that = (WNSBadgeData)o;
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return !(this.glyph == null ? that.glyph != null : !this.glyph.equals(that.glyph));
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.glyph != null ? this.glyph.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private Integer value;
        private Glyph glyph;

        private Builder() {
        }

        public Builder setValue(int value) {
            this.value = value;
            return this;
        }

        public Builder setGlyph(Glyph value) {
            this.glyph = value;
            return this;
        }

        public WNSBadgeData build() {
            if (this.glyph == null && this.value == null) {
                throw new IllegalArgumentException("Must supply one of 'value' or 'glyph'.");
            }
            if (this.glyph != null && this.value != null) {
                throw new IllegalArgumentException("Must supply one of 'value' or 'glyph', but not both.");
            }
            return new WNSBadgeData(Optional.fromNullable((Object)this.value), Optional.fromNullable((Object)((Object)this.glyph)));
        }
    }

    public static enum Glyph {
        NONE,
        ACTIVITY,
        ALERT,
        AVAILABLE,
        AWAY,
        BUSY,
        NEW_MESSAGE,
        PAUSED,
        PLAYING,
        UNAVAILABLE,
        ERROR,
        ATTENTION;

        private final String id = this.name().toLowerCase().replace('_', '-');

        public String getIdentifier() {
            return this.id;
        }

        public static Glyph get(String value) {
            for (Glyph glyph : Glyph.values()) {
                if (!value.equalsIgnoreCase(glyph.getIdentifier())) continue;
                return glyph;
            }
            return null;
        }
    }
}

