/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model;

import com.google.common.base.Optional;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.push.model.PushModelObject;
import org.joda.time.DateTime;

public class PushExpiry
extends PushModelObject {
    private final Optional<Integer> expirySeconds;
    private final Optional<DateTime> expiryTimeStamp;

    private PushExpiry(Optional<Integer> expirySeconds, Optional<DateTime> expiryTimeStamp) {
        this.expirySeconds = expirySeconds;
        this.expiryTimeStamp = expiryTimeStamp;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<Integer> getExpirySeconds() {
        return this.expirySeconds;
    }

    public Optional<DateTime> getExpiryTimeStamp() {
        return this.expiryTimeStamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PushExpiry that = (PushExpiry)o;
        if (this.expirySeconds != null ? !this.expirySeconds.equals(that.expirySeconds) : that.expirySeconds != null) {
            return false;
        }
        return !(this.expiryTimeStamp == null ? that.expiryTimeStamp != null : !this.expiryTimeStamp.equals(that.expiryTimeStamp));
    }

    public int hashCode() {
        int result = this.expirySeconds != null ? this.expirySeconds.hashCode() : 0;
        result = 31 * result + (this.expiryTimeStamp != null ? this.expiryTimeStamp.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PushOptionsPayload{expirySeconds=" + this.expirySeconds + ", expiryTimeStamp=" + this.expiryTimeStamp + '}';
    }

    public static class Builder {
        private Integer expirySeconds = null;
        private DateTime expiryTimeStamp = null;

        private Builder() {
        }

        public Builder setExpirySeconds(int value) {
            this.expirySeconds = value;
            return this;
        }

        public Builder setExpiryTimeStamp(DateTime value) {
            this.expiryTimeStamp = value;
            return this;
        }

        public PushExpiry build() {
            if (this.expiryTimeStamp == null && this.expirySeconds == null) {
                throw new APIParsingException("Expiry time can not be null");
            }
            if (this.expiryTimeStamp != null && this.expirySeconds != null) {
                throw new APIParsingException("Expiry time may contain a relative offset or an absolute time, but not both");
            }
            if (this.expirySeconds != null && this.expirySeconds < 0) {
                throw new APIParsingException("Expiry time may not be negative");
            }
            return new PushExpiry(Optional.fromNullable((Object)this.expirySeconds), Optional.fromNullable((Object)this.expiryTimeStamp));
        }
    }
}

