/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.nameduser.parse;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.urbanairship.api.channel.model.ChannelView;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.common.parse.StringFieldDeserializer;
import com.urbanairship.api.nameduser.model.NamedUserView;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class NamedUserViewReader
implements JsonObjectReader<NamedUserView> {
    private NamedUserView.Builder builder = NamedUserView.newBuilder();

    public void readNamedUserId(JsonParser jsonParser) throws IOException {
        this.builder.setNamedUserId(StringFieldDeserializer.INSTANCE.deserialize(jsonParser, "named_user_id"));
    }

    public void readNamedUserTags(JsonParser jsonParser) throws IOException {
        Map mutableTags = (Map)jsonParser.readValueAs((TypeReference)new TypeReference<Map<String, Set<String>>>(){});
        ImmutableMap<String, ImmutableSet<String>> tags = NamedUserViewReader.immutableMapConverter(mutableTags);
        this.builder.setNamedUserTags(tags);
    }

    public void readChannelView(JsonParser jsonParser) throws IOException {
        Set channels = (Set)jsonParser.readValueAs((TypeReference)new TypeReference<Set<ChannelView>>(){});
        this.builder.setChannelViews((ImmutableSet<ChannelView>)ImmutableSet.copyOf((Collection)channels));
    }

    @Override
    public NamedUserView validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage());
        }
    }

    private static ImmutableMap<String, ImmutableSet<String>> immutableMapConverter(Map<String, Set<String>> map) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)ImmutableSet.copyOf((Collection)entry.getValue()));
        }
        return builder.build();
    }
}

