/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.location;

import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.location.model.BoundedBox;
import com.urbanairship.api.location.model.LocationResponse;
import com.urbanairship.api.location.model.Point;
import com.urbanairship.api.location.parse.LocationObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;

public class LocationRequest
implements Request<LocationResponse> {
    private static final String API_LOCATION_PATH = "/api/location/";
    private final String path;
    private final List<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();

    private LocationRequest(String path, BasicNameValuePair parameter) {
        this.path = path;
        if (parameter != null) {
            this.parameters.add(parameter);
        }
    }

    public static LocationRequest newRequest(String query) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)query), (Object)"Query text cannot be blank");
        return new LocationRequest(API_LOCATION_PATH, new BasicNameValuePair("q", query));
    }

    public static LocationRequest newRequest(Point point) {
        Preconditions.checkNotNull((Object)point, (Object)"Point must not be null");
        return new LocationRequest(API_LOCATION_PATH + point.getLatitude() + "," + point.getLongitude(), null);
    }

    public static LocationRequest newRequest(BoundedBox boundedBox) {
        Preconditions.checkNotNull((Object)boundedBox, (Object)"Box must not be null");
        return new LocationRequest(API_LOCATION_PATH + boundedBox.getCornerOne().getLatitude() + "," + boundedBox.getCornerOne().getLongitude() + "," + boundedBox.getCornerTwo().getLatitude() + "," + boundedBox.getCornerTwo().getLongitude(), null);
    }

    public LocationRequest setType(String type) {
        this.parameters.add(new BasicNameValuePair("type", type));
        return this;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.GET;
    }

    @Override
    public String getRequestBody() {
        return null;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) throws URISyntaxException {
        URIBuilder builder = new URIBuilder(RequestUtils.resolveURI(baseUri, this.path));
        for (BasicNameValuePair parameter : this.parameters) {
            builder.addParameter(parameter.getName(), parameter.getValue());
        }
        return builder.build();
    }

    @Override
    public ResponseParser<LocationResponse> getResponseParser() {
        return new ResponseParser<LocationResponse>(){

            @Override
            public LocationResponse parse(String response) throws IOException {
                return (LocationResponse)LocationObjectMapper.getInstance().readValue(response, LocationResponse.class);
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }
}

