/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.customevents.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Map;

public class CustomEventBody {
    private final String name;
    private final Optional<BigDecimal> value;
    private final Optional<String> transaction;
    private final Optional<String> interactionId;
    private final Optional<String> interactionType;
    private final Optional<ImmutableMap<String, String>> properties;
    private final String sessionId;

    private CustomEventBody(Builder builder) {
        this.name = builder.name;
        this.value = Optional.fromNullable((Object)builder.value);
        this.transaction = Optional.fromNullable((Object)builder.transaction);
        this.interactionId = Optional.fromNullable((Object)builder.interactionId);
        this.interactionType = Optional.fromNullable((Object)builder.interactionType);
        this.properties = builder.properties.build().isEmpty() ? Optional.absent() : Optional.of((Object)builder.properties.build());
        this.sessionId = builder.sessionId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public Optional<BigDecimal> getValue() {
        return this.value;
    }

    public Optional<String> getTransaction() {
        return this.transaction;
    }

    public Optional<String> getInteractionId() {
        return this.interactionId;
    }

    public Optional<String> getInteractionType() {
        return this.interactionType;
    }

    public Optional<ImmutableMap<String, String>> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomEventBody that = (CustomEventBody)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.value, that.value) && Objects.equal(this.transaction, that.transaction) && Objects.equal(this.interactionId, that.interactionId) && Objects.equal(this.interactionType, that.interactionType) && Objects.equal(this.properties, that.properties) && Objects.equal((Object)this.sessionId, (Object)that.sessionId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.value, this.transaction, this.interactionId, this.interactionType, this.properties, this.sessionId});
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public static class Builder {
        private String name = null;
        private BigDecimal value = null;
        private String transaction = null;
        private String interactionId = null;
        private String interactionType = null;
        private ImmutableMap.Builder<String, String> properties = ImmutableMap.builder();
        private String sessionId = null;

        private Builder() {
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setValue(BigDecimal value) {
            this.value = value;
            return this;
        }

        public Builder setTransaction(String transaction) {
            this.transaction = transaction;
            return this;
        }

        public Builder setInteractionId(String interactionId) {
            this.interactionId = interactionId;
            return this;
        }

        public Builder setInteractionType(String interactionType) {
            this.interactionType = interactionType;
            return this;
        }

        public Builder addPropertiesEntry(String key, String value) {
            this.properties.put((Object)key, (Object)value);
            return this;
        }

        public Builder addAllPropertyEntries(Map<String, String> entries) {
            this.properties.putAll(entries);
            return this;
        }

        public Builder setSessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public CustomEventBody build() {
            Preconditions.checkNotNull((Object)this.name, (Object)"'name' must be set");
            Preconditions.checkNotNull((Object)this.sessionId, (Object)"'sessionId' must be set");
            return new CustomEventBody(this);
        }
    }
}

