/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.customevents;

import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.customevents.model.CustomEventPayload;
import com.urbanairship.api.customevents.model.CustomEventResponse;
import com.urbanairship.api.push.parse.PushObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class CustomEventRequest
implements Request<CustomEventResponse> {
    private static final String API_CUSTOM_EVENTS_PATH = "/api/custom-events/";
    private final CustomEventPayload payload;

    private CustomEventRequest(CustomEventPayload payload) {
        Preconditions.checkNotNull((Object)payload, (Object)"Payload required when creating a custom-events request");
        this.payload = payload;
    }

    public static CustomEventRequest newRequest(CustomEventPayload customEventPayload) {
        return new CustomEventRequest(customEventPayload);
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        return this.payload.toJSON();
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) throws URISyntaxException {
        return RequestUtils.resolveURI(baseUri, API_CUSTOM_EVENTS_PATH);
    }

    @Override
    public ResponseParser<CustomEventResponse> getResponseParser() {
        return new ResponseParser<CustomEventResponse>(){

            @Override
            public CustomEventResponse parse(String response) throws IOException {
                return (CustomEventResponse)PushObjectMapper.getInstance().readValue(response, CustomEventResponse.class);
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return true;
    }
}

