/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.io.BaseEncoding;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.ResponseFilter;
import com.urbanairship.api.client.ProxyInfo;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestRetryFilter;
import com.urbanairship.api.client.Response;
import com.urbanairship.api.client.ResponseAsyncHandler;
import com.urbanairship.api.client.ResponseCallback;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrbanAirshipClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(UrbanAirshipClient.class);
    private final String appKey;
    private final Optional<String> appSecret;
    private final Optional<String> bearerToken;
    private final URI baseUri;
    private final AsyncHttpClient client;

    private UrbanAirshipClient(Builder builder) {
        this.appKey = builder.key;
        this.appSecret = Optional.fromNullable((Object)builder.secret);
        this.bearerToken = Optional.fromNullable((Object)builder.bearerToken);
        this.baseUri = URI.create(builder.baseUri);
        AsyncHttpClientConfig.Builder clientConfigBuilder = builder.clientConfigBuilder;
        clientConfigBuilder.setUserAgent(this.getUserAgent());
        clientConfigBuilder.addResponseFilter((ResponseFilter)new RequestRetryFilter(builder.maxRetries, (Optional<Predicate<FilterContext>>)Optional.fromNullable((Object)builder.retryPredicate)));
        Optional<ProxyServer> proxyServer = this.convertProxyInfo((Optional<ProxyInfo>)Optional.fromNullable((Object)builder.proxyInfo));
        if (proxyServer.isPresent()) {
            clientConfigBuilder.setProxyServer((ProxyServer)proxyServer.get());
        }
        this.client = new AsyncHttpClient(clientConfigBuilder.build());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getAppKey() {
        return this.appKey;
    }

    public Optional<String> getAppSecret() {
        return this.appSecret;
    }

    public Optional<String> getBearerToken() {
        return this.bearerToken;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public AsyncHttpClient getClient() {
        return this.client;
    }

    public <T> Future<Response> executeAsync(Request<T> request, ResponseCallback callback) throws IOException {
        String auth;
        AsyncHttpClient.BoundRequestBuilder requestBuilder;
        String uri;
        try {
            uri = request.getUri(this.baseUri).toString();
        }
        catch (URISyntaxException e) {
            log.error("Failed to generate a request URI from base URI " + this.baseUri.toString(), (Throwable)e);
            throw new RuntimeException(e);
        }
        switch (request.getHttpMethod()) {
            case GET: {
                requestBuilder = this.client.prepareGet(uri);
                break;
            }
            case PUT: {
                requestBuilder = this.client.preparePut(uri);
                break;
            }
            case POST: {
                requestBuilder = this.client.preparePost(uri);
                break;
            }
            case DELETE: {
                requestBuilder = this.client.prepareDelete(uri);
                break;
            }
            default: {
                requestBuilder = this.client.prepareGet(uri);
            }
        }
        Map<String, String> requestHeaders = request.getRequestHeaders();
        if (requestHeaders != null) {
            for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                requestBuilder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (request.bearerTokenAuthRequired()) {
            Preconditions.checkNotNull((Object)this.bearerToken.get(), (Object)("Bearer token required for request: " + request));
            auth = "Bearer " + (String)this.bearerToken.get();
        } else {
            Preconditions.checkNotNull((Object)this.appSecret.get(), (Object)("App secret required for request: " + request));
            auth = "Basic " + BaseEncoding.base64().encode((this.appKey + ":" + (String)this.appSecret.get()).getBytes());
        }
        requestBuilder.addHeader("Authorization", auth).addHeader("X-UA-Appkey", this.appKey);
        String body = request.getRequestBody();
        ContentType contentType = request.getContentType();
        if (body != null && contentType != null) {
            requestBuilder.setBody(body.getBytes(contentType.getCharset()));
        }
        log.debug(String.format("Executing Urban Airship request to %s with body %s.", uri, request.getRequestBody()));
        ResponseAsyncHandler<T> handler = new ResponseAsyncHandler<T>((Optional<ResponseCallback>)Optional.fromNullable((Object)callback), request.getResponseParser());
        return requestBuilder.execute(handler);
    }

    public <T> Future<Response> executeAsync(Request<T> request) throws IOException {
        return this.executeAsync(request, null);
    }

    public <T> Response execute(Request<T> request, ResponseCallback callback) throws IOException {
        try {
            return this.executeAsync(request, callback).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Thread interrupted while retrieving response from future", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to retrieve response from future", e);
        }
    }

    public <T> Response execute(Request<T> request) throws IOException {
        return this.execute(request, null);
    }

    @Override
    public void close() {
        log.info("Closing client");
        this.client.close();
    }

    @VisibleForTesting
    public String getUserAgent() {
        String userAgent = "UNKNOWN";
        InputStream stream = this.getClass().getResourceAsStream("/client.properties");
        if (stream != null) {
            Properties props = new Properties();
            try {
                props.load(stream);
                stream.close();
                userAgent = "UAJavaLib/" + props.get("client.version");
            }
            catch (IOException e) {
                log.error("Failed to retrieve client user agent due to IOException - setting to \"UNKNOWN\"", (Throwable)e);
            }
        }
        return userAgent;
    }

    private Optional<ProxyServer> convertProxyInfo(Optional<ProxyInfo> proxyInfo) {
        if (proxyInfo.isPresent()) {
            ProxyServer.Protocol protocol = ProxyServer.Protocol.HTTPS;
            for (ProxyServer.Protocol proto : ProxyServer.Protocol.values()) {
                if (!((ProxyInfo)proxyInfo.get()).getProtocol().equals(proto.getProtocol())) continue;
                protocol = proto;
            }
            ProxyServer proxyServer = new ProxyServer(protocol, ((ProxyInfo)proxyInfo.get()).getHost(), ((ProxyInfo)proxyInfo.get()).getPort().intValue(), ((ProxyInfo)proxyInfo.get()).getPrincipal(), ((ProxyInfo)proxyInfo.get()).getPassword());
            return Optional.of((Object)proxyServer);
        }
        return Optional.absent();
    }

    public String toString() {
        return "UrbanAirshipClient{appKey='" + this.appKey + '\'' + ", appSecret='" + (String)this.appSecret.get() + '\'' + ", baseUri=" + this.baseUri + ", client=" + this.client + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UrbanAirshipClient)) {
            return false;
        }
        UrbanAirshipClient that = (UrbanAirshipClient)o;
        if (this.appKey != null ? !this.appKey.equals(that.appKey) : that.appKey != null) {
            return false;
        }
        if (this.appSecret != null ? !this.appSecret.equals(that.appSecret) : that.appSecret != null) {
            return false;
        }
        if (this.baseUri != null ? !this.baseUri.equals(that.baseUri) : that.baseUri != null) {
            return false;
        }
        return !(this.client != null ? !this.client.equals(that.client) : that.client != null);
    }

    public int hashCode() {
        int result = this.appKey != null ? this.appKey.hashCode() : 0;
        result = 31 * result + (this.appSecret != null ? this.appSecret.hashCode() : 0);
        result = 31 * result + (this.baseUri != null ? this.baseUri.hashCode() : 0);
        result = 31 * result + (this.client != null ? this.client.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String key;
        private String secret;
        private String baseUri = "https://go.urbanairship.com";
        private String bearerToken;
        private Integer maxRetries = 10;
        private AsyncHttpClientConfig.Builder clientConfigBuilder = new AsyncHttpClientConfig.Builder();
        private ProxyInfo proxyInfo = null;
        private Predicate<FilterContext> retryPredicate = null;

        private Builder() {
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setSecret(String appSecret) {
            this.secret = appSecret;
            return this;
        }

        public Builder setBearerToken(String bearerToken) {
            this.bearerToken = bearerToken;
            return this;
        }

        public Builder setBaseUri(String URI2) {
            this.baseUri = URI2;
            return this;
        }

        public Builder setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder setClientConfigBuilder(AsyncHttpClientConfig.Builder builder) {
            this.clientConfigBuilder = builder;
            return this;
        }

        public Builder setProxyInfo(ProxyInfo proxyInfo) {
            this.proxyInfo = proxyInfo;
            return this;
        }

        public Builder setRetryPredicate(Predicate<FilterContext> retryPredicate) {
            this.retryPredicate = retryPredicate;
            return this;
        }

        public UrbanAirshipClient build() {
            Preconditions.checkNotNull((Object)this.key, (Object)"app key needed to build APIClient");
            Preconditions.checkNotNull((Object)this.baseUri, (Object)"base URI needed to build APIClient");
            Preconditions.checkNotNull((Object)this.maxRetries, (Object)"max non-POST retries needed to build APIClient");
            Preconditions.checkNotNull((Object)this.clientConfigBuilder, (Object)"Async HTTP client config builder needed to build APIClient");
            if (this.secret == null && this.bearerToken == null) {
                throw new NullPointerException("secret or the bearer token must be set");
            }
            return new UrbanAirshipClient(this);
        }
    }
}

