/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model.open;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class OpenChannel {
    private final String openPlatformName;
    private final Optional<String> oldAddress;
    private final Optional<ImmutableMap<String, String>> identifiers;

    private OpenChannel() {
        this(null, (Optional<String>)Optional.absent(), (Optional<ImmutableMap<String, String>>)Optional.absent());
    }

    public String toString() {
        return "OpenChannel{openPlatformName='" + this.openPlatformName + '\'' + ", oldAddress=" + this.oldAddress + ", identifiers=" + this.identifiers + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenChannel that = (OpenChannel)o;
        return Objects.equal((Object)this.openPlatformName, (Object)that.openPlatformName) && Objects.equal(this.oldAddress, that.oldAddress) && Objects.equal(this.identifiers, that.identifiers);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.openPlatformName, this.oldAddress, this.identifiers});
    }

    private OpenChannel(String openPlatformName, Optional<String> oldAddress, Optional<ImmutableMap<String, String>> identifiers) {
        this.openPlatformName = openPlatformName;
        this.oldAddress = oldAddress;
        this.identifiers = identifiers;
    }

    private OpenChannel(Builder builder) {
        this.openPlatformName = builder.openPlatformName;
        this.oldAddress = Optional.fromNullable((Object)builder.oldAddress);
        this.identifiers = builder.identifiers.build().isEmpty() ? Optional.absent() : Optional.of((Object)builder.identifiers.build());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getOpenPlatformName() {
        return this.openPlatformName;
    }

    public Optional<String> getOldAddress() {
        return this.oldAddress;
    }

    public Optional<ImmutableMap<String, String>> getIdentifiers() {
        return this.identifiers;
    }

    public static final class Builder {
        private String openPlatformName = null;
        private String oldAddress = null;
        private ImmutableMap.Builder<String, String> identifiers = ImmutableMap.builder();

        private Builder() {
        }

        public Builder setOpenPlatformName(String platformName) {
            this.openPlatformName = platformName;
            return this;
        }

        public Builder setOldAddress(String oldAddress) {
            this.oldAddress = oldAddress;
            return this;
        }

        public Builder addIdentifier(String key, String value) {
            this.identifiers.put((Object)key, (Object)value);
            return this;
        }

        public Builder addAllIdentifierEntries(Map<String, String> entries) {
            this.identifiers.putAll(entries);
            return this;
        }

        public OpenChannel build() {
            Preconditions.checkNotNull((Object)this.openPlatformName, (Object)"Open platform name must not be null.");
            return new OpenChannel(this);
        }
    }
}

