/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model.ios;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.urbanairship.api.channel.model.ios.QuietTime;

public final class IosSettings {
    private final int badge;
    private final Optional<QuietTime> quiettime;
    private final Optional<String> timezone;

    private IosSettings(int badge, Optional<QuietTime> quiettime, Optional<String> timezone) {
        this.badge = badge;
        this.quiettime = quiettime;
        this.timezone = timezone;
    }

    private IosSettings() {
        this(0, (Optional<QuietTime>)Optional.absent(), (Optional<String>)Optional.absent());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int getBadge() {
        return this.badge;
    }

    public Optional<QuietTime> getQuietTime() {
        return this.quiettime;
    }

    public Optional<String> getTimezone() {
        return this.timezone;
    }

    public String toString() {
        return "IosSettings{badge=" + this.badge + ", quiettime=" + this.quiettime + ", timezone=" + this.timezone + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.badge, this.quiettime, this.timezone});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IosSettings other = (IosSettings)obj;
        return Objects.equal((Object)this.badge, (Object)other.badge) && Objects.equal(this.quiettime, other.quiettime) && Objects.equal(this.timezone, other.timezone);
    }

    public static final class Builder {
        private int badge = 0;
        private QuietTime quiettime = null;
        private String timezone = null;

        private Builder() {
        }

        public Builder setBadge(int badge) {
            this.badge = badge;
            return this;
        }

        public Builder setQuietTime(QuietTime quiettime) {
            this.quiettime = quiettime;
            return this;
        }

        public Builder setTimeZone(String timeZone) {
            this.timezone = timeZone;
            return this;
        }

        public IosSettings build() {
            Preconditions.checkArgument((this.badge >= 0 ? 1 : 0) != 0, (Object)"'badge' must be non-negative.");
            return new IosSettings(this.badge, Optional.fromNullable((Object)this.quiettime), Optional.fromNullable((Object)this.timezone));
        }
    }
}

