/*
 * Decompiled with CFR 0.152.
 */
package com.upplication.s3fs;

import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.upplication.s3fs.S3FileStore;
import com.upplication.s3fs.S3FileSystem;
import com.upplication.s3fs.S3Path;
import com.upplication.s3fs.util.S3Utils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class S3Iterator
implements Iterator<Path> {
    private S3FileSystem fileSystem;
    private S3FileStore fileStore;
    private String key;
    private List<S3Path> items = Lists.newArrayList();
    private Set<S3Path> addedVirtualDirectories = Sets.newHashSet();
    private ObjectListing current;
    private int cursor;
    private int size;
    private boolean incremental;
    private S3Utils s3Utils = new S3Utils();

    public S3Iterator(S3Path path) {
        this(path, false);
    }

    public S3Iterator(S3Path path, boolean incremental) {
        this(path.getFileStore(), path.getKey() + (!incremental && !path.getKey().isEmpty() && !path.getKey().endsWith("/") ? "/" : ""), incremental);
    }

    public S3Iterator(S3FileStore fileStore, String key, boolean incremental) {
        ListObjectsRequest listObjectsRequest = this.buildRequest(fileStore.name(), key, incremental);
        this.fileStore = fileStore;
        this.fileSystem = fileStore.getFileSystem();
        this.key = key;
        this.current = this.fileSystem.getClient().listObjects(listObjectsRequest);
        this.incremental = incremental;
        this.loadObjects();
    }

    @Override
    public boolean hasNext() {
        return this.cursor != this.size || this.current.isTruncated();
    }

    @Override
    public S3Path next() {
        if (this.cursor == this.size && this.current.isTruncated()) {
            this.current = this.fileSystem.getClient().listNextBatchOfObjects(this.current);
            this.loadObjects();
        }
        if (this.cursor == this.size) {
            throw new NoSuchElementException();
        }
        return this.items.get(this.cursor++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void loadObjects() {
        this.items.clear();
        if (this.incremental) {
            this.parseObjects();
        } else {
            this.parseObjectListing(this.key, this.items, this.current);
        }
        this.size = this.items.size();
        this.cursor = 0;
    }

    private void parseObjects() {
        for (S3ObjectSummary objectSummary : this.current.getObjectSummaries()) {
            String objectSummaryKey = objectSummary.getKey();
            String[] keyParts = this.fileSystem.key2Parts(objectSummaryKey);
            this.addParentPaths(keyParts);
            S3Path path = new S3Path(this.fileSystem, "/" + this.fileStore.name(), keyParts);
            if (this.items.contains(path)) continue;
            this.items.add(path);
        }
    }

    private void addParentPaths(String[] keyParts) {
        if (keyParts.length <= 1) {
            return;
        }
        String[] subParts = Arrays.copyOf(keyParts, keyParts.length - 1);
        ArrayList<S3Path> parentPaths = new ArrayList<S3Path>();
        while (subParts.length > 0) {
            S3Path path = new S3Path(this.fileSystem, "/" + this.fileStore.name(), subParts);
            String prefix = this.current.getPrefix();
            String parentKey = path.getKey();
            if (prefix.length() > parentKey.length() && prefix.contains(parentKey)) break;
            if (this.items.contains(path) || this.addedVirtualDirectories.contains(path)) {
                subParts = Arrays.copyOf(subParts, subParts.length - 1);
                continue;
            }
            parentPaths.add(path);
            this.addedVirtualDirectories.add(path);
            subParts = Arrays.copyOf(subParts, subParts.length - 1);
        }
        Collections.reverse(parentPaths);
        this.items.addAll(parentPaths);
    }

    private void parseObjectListing(String key, List<S3Path> listPath, ObjectListing current) {
        for (String commonPrefix : current.getCommonPrefixes()) {
            if (commonPrefix.equals("/")) continue;
            listPath.add(new S3Path(this.fileSystem, "/" + this.fileStore.name(), this.fileSystem.key2Parts(commonPrefix)));
        }
        for (S3ObjectSummary objectSummary : current.getObjectSummaries()) {
            String objectSummaryKey = objectSummary.getKey();
            String immediateDescendantKey = this.getImmediateDescendant(key, objectSummaryKey);
            if (immediateDescendantKey == null) continue;
            S3Path descendentPart = new S3Path(this.fileSystem, "/" + this.fileStore.name(), this.fileSystem.key2Parts(immediateDescendantKey));
            descendentPart.setFileAttributes(this.s3Utils.toS3FileAttributes(objectSummary, descendentPart.getKey()));
            if (listPath.contains(descendentPart)) continue;
            listPath.add(descendentPart);
        }
    }

    private String getImmediateDescendant(String keyParent, String keyChild) {
        int parentLen;
        keyParent = this.deleteExtraPath(keyParent);
        String childWithoutParent = this.deleteExtraPath((keyChild = this.deleteExtraPath(keyChild)).substring(parentLen = keyParent.length()));
        String[] parts = childWithoutParent.split("/");
        if (parts.length > 0 && !parts[0].isEmpty()) {
            return keyParent + "/" + parts[0];
        }
        return null;
    }

    private String deleteExtraPath(String keyChild) {
        if (keyChild.startsWith("/")) {
            keyChild = keyChild.substring(1);
        }
        if (keyChild.endsWith("/")) {
            keyChild = keyChild.substring(0, keyChild.length() - 1);
        }
        return keyChild;
    }

    ListObjectsRequest buildRequest(String bucketName, String key, boolean incremental) {
        return this.buildRequest(bucketName, key, incremental, null);
    }

    ListObjectsRequest buildRequest(String bucketName, String key, boolean incremental, Integer maxKeys) {
        if (incremental) {
            return new ListObjectsRequest(bucketName, key, null, null, maxKeys);
        }
        return new ListObjectsRequest(bucketName, key, key, "/", maxKeys);
    }
}

