/*
 * Decompiled with CFR 0.152.
 */
package com.updateimpact;

import com.google.gson.Gson;
import com.updateimpact.Dependency;
import com.updateimpact.DependencyChild;
import com.updateimpact.DependencyId;
import com.updateimpact.DependencyReport;
import com.updateimpact.ModuleDependencies;
import com.updateimpact.ReportSubmitter;
import com.updateimpact.SubmitLogger;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.ScopeArtifactFilter;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;

@Mojo(name="submit", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class UpdateImpactMojo
extends AbstractMojo {
    private static final UUID BUILD_ID = UUID.randomUUID();
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component
    private DependencyTreeBuilder dependencyTreeBuilder;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(required=true, property="updateimpact.apikey")
    private String apikey;
    @Parameter(required=true, property="updateimpact.url", defaultValue="https://app.updateimpact.com")
    private String url;
    @Parameter(required=true, property="updateimpact.openbrowser", defaultValue="true")
    private boolean openBrowser;
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    private List<MavenProject> reactorProjects;

    public void execute() throws MojoExecutionException {
        DependencyNode rootNode;
        ScopeArtifactFilter filter = new ScopeArtifactFilter("compile");
        try {
            rootNode = this.dependencyTreeBuilder.buildDependencyTree(this.project, this.localRepository, (ArtifactFilter)filter);
        }
        catch (DependencyTreeBuilderException e) {
            throw new MojoExecutionException("Exception when building the dependency tree", (Exception)((Object)e));
        }
        DependencyReport report = this.createReport(rootNode);
        String reportJson = new Gson().toJson((Object)report);
        SubmitLogger log = new SubmitLogger(){

            public void info(String message) {
                UpdateImpactMojo.this.getLog().info((CharSequence)message);
            }

            public void error(String message) {
                UpdateImpactMojo.this.getLog().error((CharSequence)message);
            }
        };
        String link = new ReportSubmitter(this.url, log).trySubmitReport(reportJson);
        if (link != null && this.openBrowser) {
            this.getLog().info((CharSequence)"Trying to open the report in the default browser ... (you can disable this by setting the updateimpact.openbrowser property to false)");
            this.openLinkIfLastProject(link);
        }
    }

    private DependencyReport createReport(DependencyNode rootNode) {
        DependencyId rootNodeId = this.dependencyIdFromNode(rootNode);
        final HashMap allDependencies = new HashMap();
        rootNode.accept(new DependencyNodeVisitor(){

            public boolean visit(DependencyNode node) {
                if (node.getState() == 0) {
                    ArrayList<DependencyChild> children = new ArrayList<DependencyChild>();
                    for (DependencyNode childNode : node.getChildren()) {
                        children.add(UpdateImpactMojo.this.dependencyChildFromNode(childNode));
                    }
                    DependencyId newDependencyId = UpdateImpactMojo.this.dependencyIdFromNode(node);
                    if (allDependencies.containsKey(newDependencyId)) {
                        UpdateImpactMojo.this.getLog().warn((CharSequence)("Duplicate dependency: " + node));
                    } else {
                        allDependencies.put(newDependencyId, new Dependency(newDependencyId, children.size() > 0 ? children : null));
                    }
                }
                return true;
            }

            public boolean endVisit(DependencyNode node) {
                return true;
            }
        });
        return new DependencyReport(this.getProjectName(), this.apikey, this.buildId(), Collections.singletonList(new ModuleDependencies(rootNodeId, "test", allDependencies.values())), "1.0", "maven-plugin-1.0.4");
    }

    private String buildId() {
        return BUILD_ID.toString();
    }

    private void openLinkIfLastProject(String viewLink) throws MojoExecutionException {
        if (this.project == this.reactorProjects.get(this.reactorProjects.size() - 1)) {
            try {
                this.openWebpage(viewLink);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Exception when trying to open a link in the default browser", (Exception)e);
            }
        }
    }

    private void openWebpage(String url) throws IOException {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            desktop.browse(URI.create(url));
        }
    }

    private String getProjectName() {
        MavenProject mainProject = this.project;
        for (MavenProject reactorProject : this.reactorProjects) {
            if (!reactorProject.isExecutionRoot()) continue;
            mainProject = reactorProject;
        }
        return mainProject.getName();
    }

    private DependencyId dependencyIdFromNode(DependencyNode node) {
        return new DependencyId(node.getArtifact().getGroupId(), node.getArtifact().getArtifactId(), node.getArtifact().getVersion(), node.getArtifact().getType(), node.getArtifact().getClassifier());
    }

    private DependencyChild dependencyChildFromNode(DependencyNode node) {
        return new DependencyChild(this.dependencyIdFromNode(node), node.getState() == 2 ? node.getRelatedArtifact().getVersion() : null, node.getState() == 3 ? Boolean.valueOf(true) : null);
    }
}

