/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.remote;

import com.univocity.api.common.Args;
import com.univocity.parsers.common.Nesting;
import com.univocity.parsers.remote.NextInputHandler;
import com.univocity.parsers.remote.PaginationContext;
import com.univocity.parsers.remote.RemoteEntitySettings;
import com.univocity.parsers.remote.RemoteParserSettings;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public abstract class Paginator<E extends RemoteEntitySettings, P extends PaginationContext> {
    protected final E entitySettings;
    private int followCount = -1;
    private NextInputHandler<P> paginationHandler;
    private boolean urlTestingEnabled = false;
    public static final String ENTITY_NAME = "*paginator*";
    public static final String CURRENT_PAGE = "currentPage";
    public static final String CURRENT_PAGE_NUMBER = "currentPageNumber";
    public static final String NEXT_PAGE = "nextPage";
    public static final String NEXT_PAGE_NUMBER = "nextPageNumber";
    static Set<String> RESERVED_NAMES = Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList("currentPage", "currentPageNumber", "nextPage", "nextPageNumber")));

    protected Paginator(RemoteParserSettings parserSettings) {
        this.entitySettings = this.newEntitySettings(parserSettings);
        ((RemoteEntitySettings)this.entitySettings).setNesting(Nesting.LINK);
    }

    protected abstract E newEntitySettings(RemoteParserSettings var1);

    public final void setFollowCount(int followCount) {
        Args.positiveOrZero((Number)followCount, (String)"Follow count");
        this.followCount = followCount;
    }

    public final int getFollowCount() {
        return this.followCount;
    }

    public final void setPaginationHandler(NextInputHandler<P> paginationHandler) {
        this.paginationHandler = paginationHandler;
    }

    public NextInputHandler<P> getPaginationHandler() {
        return this.paginationHandler;
    }

    public final Set<String> getFieldNames() {
        return ((RemoteEntitySettings)this.entitySettings).getFieldNames();
    }

    public boolean isUrlTestingEnabled() {
        return this.urlTestingEnabled;
    }

    public void setUrlTestingEnabled(boolean urlTestingEnabled) {
        this.urlTestingEnabled = urlTestingEnabled;
    }
}

