/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.api.common.Args;
import com.univocity.parsers.common.Result;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class Results<R extends Result>
implements Map<String, R> {
    private final Map<String, R> normalizedKeyMap = new HashMap<String, R>();
    private final Map<String, R> originalKeyMap = new LinkedHashMap<String, R>();

    public final R join(String masterEntity, String entityToLink, String ... otherEntitiesToLink) {
        Object master = this.get(masterEntity);
        Object linked = this.get(entityToLink);
        Result out = master.join(linked, new String[0]);
        for (String entityName : otherEntitiesToLink) {
            out = out.join(this.get(entityName), new String[0]);
        }
        return (R)out;
    }

    public final void link(String masterEntity, String entityToLink, String ... otherEntitiesToLink) {
        Object master = this.get(masterEntity);
        Object linked = this.get(entityToLink);
        master.link(linked, new String[0]);
        for (String entityName : otherEntitiesToLink) {
            master.link(this.get(entityName), new String[0]);
        }
    }

    private String getValidatedKey(Object entityName) {
        if (this.normalizedKeyMap.isEmpty()) {
            throw new IllegalArgumentException("Empty results. Entity '" + entityName + "' not found. ");
        }
        String key = this.getNormalizedKey(entityName);
        if (!this.normalizedKeyMap.containsKey(key)) {
            throw new IllegalArgumentException("Entity name '" + entityName + "' not found in results. Available entities: " + this.originalKeyMap.keySet());
        }
        return key;
    }

    private String getNormalizedKey(Object entityName) {
        Args.notNull((Object)entityName, (String)"Entity name");
        String key = entityName.toString().trim();
        Args.notBlank((CharSequence)key, (String)"Entity name");
        return key.toLowerCase();
    }

    @Override
    public final R put(String entityName, Object result) {
        this.normalizedKeyMap.put(this.getNormalizedKey(entityName), (Result)result);
        return (R)this.originalKeyMap.put(entityName, (Result)result);
    }

    @Override
    public final R put(String entityName, R result) {
        this.normalizedKeyMap.put(this.getNormalizedKey(entityName), result);
        return (R)((Result)this.originalKeyMap.put(entityName, result));
    }

    @Override
    public final R get(Object entityName) {
        return (R)((Result)this.normalizedKeyMap.get(this.getValidatedKey(entityName)));
    }

    @Override
    public final R remove(Object entityName) {
        Result out = (Result)this.normalizedKeyMap.remove(this.getValidatedKey(entityName));
        if (out != null) {
            Iterator<String> it = this.originalKeyMap.keySet().iterator();
            while (it.hasNext()) {
                String value = it.next();
                if (!value.equalsIgnoreCase(entityName.toString())) continue;
                it.remove();
                break;
            }
        }
        return (R)out;
    }

    @Override
    public final boolean containsValue(Object entityName) {
        return this.normalizedKeyMap.containsValue(this.getNormalizedKey(entityName));
    }

    @Override
    public final boolean containsKey(Object entityName) {
        return this.normalizedKeyMap.containsKey(this.getNormalizedKey(entityName));
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.originalKeyMap.keySet());
    }

    @Override
    public final Set<Map.Entry<String, R>> entrySet() {
        return Collections.unmodifiableSet(this.originalKeyMap.entrySet());
    }

    @Override
    public final Collection<R> values() {
        return Collections.unmodifiableCollection(this.originalKeyMap.values());
    }

    @Override
    public int size() {
        return this.originalKeyMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.originalKeyMap.isEmpty();
    }

    @Override
    public void putAll(Map<? extends String, ? extends R> m) {
        for (Map.Entry<String, R> e : m.entrySet()) {
            this.put(String.valueOf(e.getKey()), (R)((Result)e.getValue()));
        }
    }

    @Override
    public void clear() {
        this.normalizedKeyMap.clear();
        this.originalKeyMap.clear();
    }
}

