/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.api.Range;
import com.univocity.api.UI;
import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.CommonParserSettings;
import com.univocity.parsers.common.Context;
import com.univocity.parsers.common.EntityList;
import com.univocity.parsers.common.EntitySettings;
import com.univocity.parsers.common.ProcessorErrorHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public abstract class EntityParserSettings<S extends CommonParserSettings, L extends EntityList, C extends Context>
implements Cloneable {
    protected Set<String> entitiesToRead = new TreeSet<String>();
    protected Set<String> entitiesToSkip = new TreeSet<String>();
    protected S globalSettings = this.createGlobalSettings();

    protected static final CommonParserSettings createEmptyGlobalSettings() {
        return EntitySettings.createEmptyParserSettings();
    }

    protected abstract S createGlobalSettings();

    private static String[] toArray(Collection<String> collection) {
        return collection == null ? ArgumentUtils.EMPTY_STRING_ARRAY : collection.toArray(new String[0]);
    }

    public final void addEntitiesToRead(Collection<String> entitiesToRead) {
        this.addEntitiesToRead(EntityParserSettings.toArray(entitiesToRead));
    }

    public final void addEntitiesToRead(String ... entitiesToRead) {
        for (String entity : entitiesToRead) {
            ArgumentUtils.noNulls((String)"Name of entity to be read", (Object[])new String[]{entity});
            this.entitiesToRead.add(entity);
        }
    }

    public final void addEntitiesToSkip(Collection<String> entitiesToSkip) {
        this.setEntitiesToSkip(EntityParserSettings.toArray(entitiesToSkip));
    }

    public final Set<String> getEntitiesToRead() {
        return Collections.unmodifiableSet(this.entitiesToRead);
    }

    public final void setEntitiesToRead(Collection<String> entitiesToRead) {
        this.setEntitiesToRead(EntityParserSettings.toArray(entitiesToRead));
    }

    public final void setEntitiesToRead(String ... entitiesToRead) {
        this.entitiesToRead.clear();
        this.addEntitiesToRead(entitiesToRead);
    }

    public final Set<String> getEntitiesToSkip() {
        return Collections.unmodifiableSet(this.entitiesToSkip);
    }

    public final void setEntitiesToSkip(String ... entitiesToSkip) {
        this.entitiesToSkip.clear();
        this.addEntitiesToSkip(entitiesToSkip);
    }

    public final void addEntitiesToSkip(String ... entitiesToSkip) {
        for (String entity : entitiesToSkip) {
            ArgumentUtils.noNulls((String)"Name of entity to be skipped", (Object[])new String[]{entity});
            this.entitiesToSkip.add(entity);
        }
    }

    public final void setEntitiesToSkip(Collection<String> entitiesToSkip) {
        this.setEntitiesToSkip(EntityParserSettings.toArray(entitiesToSkip));
    }

    public final boolean shouldSkip(String entityName) {
        return this.entitiesToSkip.contains(entityName) || !this.entitiesToRead.isEmpty() && !this.entitiesToRead.contains(entityName);
    }

    public final boolean shouldRead(String entityName) {
        return !this.entitiesToRead.isEmpty() && this.entitiesToRead.contains(entityName);
    }

    public final ProcessorErrorHandler<C> getProcessorErrorHandler() {
        return this.globalSettings.getProcessorErrorHandler();
    }

    public final void setProcessorErrorHandler(ProcessorErrorHandler<C> processorErrorHandler) {
        this.globalSettings.setProcessorErrorHandler(processorErrorHandler);
    }

    public final boolean getTrimTrailingWhitespaces() {
        return this.globalSettings.getIgnoreTrailingWhitespaces();
    }

    @UI(order=4)
    public final void setTrimTrailingWhitespaces(boolean trimTrailingWhitespaces) {
        this.globalSettings.setIgnoreTrailingWhitespaces(trimTrailingWhitespaces);
    }

    public final boolean getTrimLeadingWhitespaces() {
        return this.globalSettings.getIgnoreLeadingWhitespaces();
    }

    @UI(order=4)
    public final void setTrimLeadingWhitespaces(boolean trimTrailingWhitespaces) {
        this.globalSettings.setIgnoreLeadingWhitespaces(trimTrailingWhitespaces);
    }

    public final void trimValues(boolean trim) {
        this.globalSettings.trimValues(trim);
    }

    public final int getErrorContentLength() {
        return this.globalSettings.getErrorContentLength();
    }

    @Range(min=0, max=300)
    @UI(order=10)
    public final void setErrorContentLength(int errorContentLength) {
        this.globalSettings.setErrorContentLength(errorContentLength);
    }

    public final String getNullValue() {
        return this.globalSettings.getNullValue();
    }

    @UI
    public final void setNullValue(String nullValue) {
        this.globalSettings.setNullValue(nullValue);
    }

    protected EntityParserSettings<S, L, C> clone() {
        try {
            EntityParserSettings out = (EntityParserSettings)super.clone();
            out.entitiesToRead = new TreeSet<String>();
            out.entitiesToSkip = new TreeSet<String>();
            out.globalSettings = this.globalSettings.clone(true);
            return out;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Unable to clone", e);
        }
    }
}

